/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.startup;

import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.ejb.containers.AbstractSingletonContainer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.ee.authorize.PolicyLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.startup.SingletonLifeCycleManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejb")
@PerLookup
public class EjbApplication
implements ApplicationContainer<Collection<EjbDescriptor>> {
    static final String KEEP_STATE = "org.glassfish.ejb.startup.keepstate";
    private static final String CONTAINER_LIST_KEY = "org.glassfish.ejb.startup.EjbContainerList";
    private static final String EJB_APP_MARKED_AS_STARTED_STATUS = "org.glassfish.ejb.startup.EjbApplicationMarkedAsStarted";
    private static final Logger _logger = LogDomains.getLogger(EjbApplication.class, (String)"jakarta.enterprise.system.container.ejb");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbApplication.class);
    private final EjbBundleDescriptorImpl ejbBundle;
    private final Collection<EjbDescriptor> ejbs;
    private final Collection<Container> containers = new ArrayList<Container>();
    private final ClassLoader ejbAppClassLoader;
    private final DeploymentContext dc;
    private final ServiceLocator services;
    private SingletonLifeCycleManager singletonLCM;
    private final PolicyLoader policyLoader;
    private final boolean initializeInOrder;
    private volatile boolean started;

    public EjbApplication(EjbBundleDescriptorImpl bundle, DeploymentContext dc, ClassLoader cl, ServiceLocator services) {
        this.ejbBundle = bundle;
        this.ejbs = bundle.getEjbs();
        this.ejbAppClassLoader = cl;
        this.dc = dc;
        this.services = services;
        this.policyLoader = (PolicyLoader)services.getService(PolicyLoader.class, new Annotation[0]);
        Application app = this.ejbBundle.getApplication();
        this.initializeInOrder = app != null && app.isInitializeInOrder();
    }

    public Collection<EjbDescriptor> getDescriptor() {
        return this.ejbs;
    }

    public EjbBundleDescriptorImpl getEjbBundleDescriptor() {
        return this.ejbBundle;
    }

    public boolean isStarted() {
        return this.started;
    }

    void markAllContainersAsStarted() {
        for (Container container : this.containers) {
            container.setStartedState();
        }
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        Boolean alreadyMarked;
        this.started = true;
        if (!this.initializeInOrder && !(alreadyMarked = (Boolean)this.dc.getTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, Boolean.class)).booleanValue()) {
            List ejbAppList = (List)this.dc.getTransientAppMetaData(CONTAINER_LIST_KEY, List.class);
            for (EjbApplication app : ejbAppList) {
                app.markAllContainersAsStarted();
            }
            this.dc.addTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, (Object)Boolean.TRUE);
        }
        try {
            DeployCommandParameters params = (DeployCommandParameters)((DeploymentContext)startupContext).getCommandParameters(DeployCommandParameters.class);
            for (Container container : this.containers) {
                container.startApplication(params.origin.isDeploy());
            }
            this.singletonLCM.doStartup(this);
        }
        catch (Exception e) {
            this.abortInitializationAfterException();
            throw e;
        }
        return true;
    }

    boolean loadContainers(ApplicationContext startupContext) {
        DeploymentContext deploymentContext = (DeploymentContext)startupContext;
        String dcMapToken = "org.glassfish.ejb.startup.SingletonLCM";
        this.singletonLCM = (SingletonLifeCycleManager)deploymentContext.getTransientAppMetaData(dcMapToken, SingletonLifeCycleManager.class);
        if (this.singletonLCM == null) {
            this.singletonLCM = new SingletonLifeCycleManager(this.initializeInOrder);
            deploymentContext.addTransientAppMetaData(dcMapToken, (Object)this.singletonLCM);
        }
        if (!this.initializeInOrder) {
            deploymentContext.addTransientAppMetaData(EJB_APP_MARKED_AS_STARTED_STATUS, (Object)Boolean.FALSE);
            ArrayList<EjbApplication> ejbAppList = (List)deploymentContext.getTransientAppMetaData(CONTAINER_LIST_KEY, List.class);
            if (ejbAppList == null) {
                ejbAppList = new ArrayList<EjbApplication>();
                deploymentContext.addTransientAppMetaData(CONTAINER_LIST_KEY, ejbAppList);
            }
            ejbAppList.add(this);
        }
        try {
            this.policyLoader.loadPolicy();
            for (EjbDescriptor desc : this.ejbs) {
                ContainerFactory ejbContainerFactory = (ContainerFactory)this.services.getService(ContainerFactory.class, desc.getContainerFactoryQualifier(), new Annotation[0]);
                if (ejbContainerFactory == null) {
                    String errMsg = localStrings.getLocalString("invalid.container.module", "Container module is not available", new Object[]{desc.getEjbTypeForDisplay()});
                    throw new IllegalStateException(errMsg);
                }
                Container container = ejbContainerFactory.createContainer(desc, this.ejbAppClassLoader, deploymentContext);
                this.containers.add(container);
                if (!(desc instanceof EjbSessionDescriptor) || !((EjbSessionDescriptor)desc).isSingleton()) continue;
                this.singletonLCM.addSingletonContainer(this, (AbstractSingletonContainer)container);
            }
        }
        catch (Throwable t) {
            this.abortInitializationAfterException();
            throw new RuntimeException("EJB Container initialization error", t);
        }
        return true;
    }

    public boolean stop(ApplicationContext stopContext) {
        boolean undeploy;
        DeploymentContext depc = (DeploymentContext)stopContext;
        OpsParams params = depc.getCommandParameters(OpsParams.class);
        boolean keepState = false;
        if (params.origin.isUndeploy() && (keepState = this.resolveKeepStateOptions(depc, false, this.ejbBundle))) {
            Properties appProps = depc.getAppProps();
            Object appId = appProps.get("org.glassfish.ejb.container.application_unique_id");
            Properties actionReportProps = null;
            if (this.ejbBundle.getApplication().isVirtual()) {
                actionReportProps = depc.getActionReport().getExtraProperties();
            } else {
                ExtendedDeploymentContext exdc = (ExtendedDeploymentContext)depc;
                actionReportProps = exdc.getParentContext().getActionReport().getExtraProperties();
            }
            actionReportProps.put("org.glassfish.ejb.container.application_unique_id", appId);
            actionReportProps.put(KEEP_STATE, String.valueOf(true));
            _logger.log(Level.INFO, "keepstate options resolved to true, saving appId {0} for application {1}.", new Object[]{appId, params.name()});
        }
        boolean bl = undeploy = params.origin.isUndeploy() || params.origin.isDeploy();
        if (undeploy) {
            ApplicationRegistry appRegistry = (ApplicationRegistry)this.services.getService(ApplicationRegistry.class, new Annotation[0]);
            ApplicationInfo appInfo = appRegistry.get(params.name());
            appInfo.addTransientAppMetaData(KEEP_STATE, (Object)keepState);
            this.ejbBundle.getApplication().setKeepStateResolved(String.valueOf(keepState));
        }
        this.singletonLCM.doShutdown();
        for (Container container : this.containers) {
            if (undeploy) {
                container.undeploy();
            } else {
                container.onShutdown();
            }
            if (container.getSecurityManager() == null) continue;
            container.getSecurityManager().destroy();
        }
        this.containers.clear();
        return true;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.ejbAppClassLoader;
    }

    boolean containsTimedObject() {
        for (Container container : this.containers) {
            if (!container.isTimedObject()) continue;
            return true;
        }
        return false;
    }

    private void abortInitializationAfterException() {
        for (Container container : this.containers) {
            container.undeploy();
        }
    }

    private boolean resolveKeepStateOptions(DeploymentContext deployContext, boolean isDeploy, EjbBundleDescriptorImpl bundleDesc) {
        Boolean isredeploy = Boolean.FALSE;
        Boolean keepState = null;
        if (isDeploy) {
            DeployCommandParameters dcp = (DeployCommandParameters)deployContext.getCommandParameters(DeployCommandParameters.class);
            if (dcp != null) {
                isredeploy = dcp.isredeploy;
                keepState = dcp.keepstate;
            }
        } else {
            UndeployCommandParameters ucp = (UndeployCommandParameters)deployContext.getCommandParameters(UndeployCommandParameters.class);
            if (ucp != null) {
                isredeploy = ucp.isredeploy;
                keepState = ucp.keepstate;
            }
        }
        if (!isredeploy.booleanValue()) {
            return false;
        }
        if (keepState == null) {
            Application app = bundleDesc.getApplication();
            keepState = app.getKeepState();
        }
        return keepState;
    }
}

