/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.ejb.EjbInvocation;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityManager;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.ee.authorization.AuthorizationUtil;
import com.sun.enterprise.security.ee.authorization.cache.PermissionCache;
import com.sun.enterprise.security.ee.authorization.cache.PermissionCacheFactory;
import com.sun.logging.LogDomains;
import jakarta.security.jacc.EJBMethodPermission;
import jakarta.security.jacc.PolicyContext;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.security.application.EjbSecurityProbeProvider;
import org.glassfish.ejb.security.application.EjbSecurityStatsProvider;
import org.glassfish.ejb.security.application.GlassFishPrincipalMapper;
import org.glassfish.ejb.security.application.GlassFishToExousiaConverter;
import org.glassfish.ejb.security.factory.EJBSecurityManagerFactory;
import org.glassfish.exousia.AuthorizationService;
import org.glassfish.exousia.permissions.RolesToPermissionsTransformer;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.security.common.Role;

public final class EJBSecurityManager
implements SecurityManager {
    private static final Logger _logger = LogDomains.getLogger(EJBSecurityManager.class, (String)"jakarta.enterprise.system.container.ejb");
    private final Map<Set<Principal>, ProtectionDomain> applicationProtectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Set<Principal>, ProtectionDomain> managerProtectionDomainCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Set<Principal>, AccessControlContext> accessControlContextCache = Collections.synchronizedMap(new WeakHashMap());
    private PermissionCache uncheckedMethodPermissionCache;
    private static final CodeSource managerCodeSource = EJBSecurityManager.class.getProtectionDomain().getCodeSource();
    private final EjbSecurityProbeProvider probeProvider = new EjbSecurityProbeProvider();
    private final EjbDescriptor deploymentDescriptor;
    private final InvocationManager invocationManager;
    private final EJBSecurityManagerFactory ejbSecurityManagerFactory;
    private final SecurityRoleMapperFactory roleMapperFactory;
    private final RunAsIdentityDescriptor runAs;
    private final AuthorizationService authorizationService;
    private static volatile EjbSecurityStatsProvider ejbStatsProvider;
    private final String contextId;
    private final CodeSource applicationCodeSource;
    private String codebase;
    private final String ejbName;
    private final String realmName;
    private final AppServerAuditManager auditManager;

    public EJBSecurityManager(EjbDescriptor ejbDescriptor, InvocationManager invMgr, EJBSecurityManagerFactory ejbSecurityManagerFactory) throws Exception {
        this.deploymentDescriptor = ejbDescriptor;
        this.invocationManager = invMgr;
        this.ejbSecurityManagerFactory = ejbSecurityManagerFactory;
        this.roleMapperFactory = AuthorizationUtil.getRoleMapperFactory();
        this.runAs = this.getRunAs(this.deploymentDescriptor);
        this.setEnterpriseBeansStatsProvider();
        this.contextId = EJBSecurityManager.getContextID(this.deploymentDescriptor);
        this.roleMapperFactory.setAppNameForContext(this.deploymentDescriptor.getApplication().getRegistrationName(), this.contextId);
        this.applicationCodeSource = EJBSecurityManager.getApplicationCodeSource(this.contextId);
        this.ejbName = this.deploymentDescriptor.getName();
        this.realmName = this.getRealmName(this.deploymentDescriptor);
        _logger.log(Level.FINE, () -> "JACC: Context id (id under which all EJB's in application will be created) = " + this.contextId);
        _logger.log(Level.FINE, () -> "Codebase (module id for ejb " + this.ejbName + ") = " + this.codebase);
        this.uncheckedMethodPermissionCache = PermissionCacheFactory.createPermissionCache((String)this.contextId, (CodeSource)this.applicationCodeSource, EJBMethodPermission.class, (String)this.ejbName);
        this.auditManager = ejbSecurityManagerFactory.getAuditManager();
        this.authorizationService = new AuthorizationService(EJBSecurityManager.getContextID(ejbDescriptor), () -> SecurityContext.getCurrent().getSubject(), () -> new GlassFishPrincipalMapper(this.contextId));
        this.authorizationService.addPermissionsToPolicy(GlassFishToExousiaConverter.convertEJBMethodPermissions(ejbDescriptor, this.contextId));
        this.authorizationService.addPermissionsToPolicy(RolesToPermissionsTransformer.createEnterpriseBeansRoleRefPermission(ejbDescriptor.getEjbBundleDescriptor().getRoles().stream().map(Role::getName).collect(Collectors.toSet()), GlassFishToExousiaConverter.getSecurityRoleRefsFromBundle(ejbDescriptor)));
    }

    public static String getContextID(EjbDescriptor ejbDescriptor) {
        return AuthorizationUtil.getContextID((EjbBundleDescriptor)ejbDescriptor.getEjbBundleDescriptor());
    }

    public boolean authorize(ComponentInvocation componentInvocation) {
        if (!(componentInvocation instanceof EjbInvocation)) {
            return false;
        }
        EjbInvocation ejbInvocation = (EjbInvocation)componentInvocation;
        if (ejbInvocation.getAuth() != null) {
            return ejbInvocation.getAuth();
        }
        SecurityContext securityContext = SecurityContext.getCurrent();
        boolean authorized = false;
        try {
            authorized = this.authorizationService.checkBeanMethodPermission(this.ejbName, ejbInvocation.getMethodInterface(), ejbInvocation.method, securityContext.getPrincipalSet());
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Unexpected exception manipulating policy context", t);
            authorized = false;
        }
        ejbInvocation.setAuth(authorized);
        this.doAuditAuthorize(securityContext, ejbInvocation, authorized);
        if (authorized && ejbInvocation.isWebService && !ejbInvocation.isPreInvokeDone()) {
            this.preInvoke(ejbInvocation);
        }
        return authorized;
    }

    public boolean isCallerInRole(String role) {
        SecurityContext securityContext;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("EJBSecurityManager", "isCallerInRole", role);
        }
        Set principalSet = (securityContext = this.getSecurityContext()) != null ? securityContext.getPrincipalSet() : null;
        return this.authorizationService.checkBeanRoleRefPermission(this.ejbName, role, principalSet);
    }

    public void preInvoke(ComponentInvocation invocation) {
        if (this.runAs == null) {
            invocation.setPreInvokeDone(true);
            return;
        }
        boolean isWebService = false;
        if (invocation instanceof EjbInvocation) {
            isWebService = ((EjbInvocation)invocation).isWebService;
        }
        if ((!isWebService || invocation.getAuth() != null && invocation.getAuth().booleanValue()) && !invocation.isPreInvokeDone()) {
            invocation.setOldSecurityContext((Object)SecurityContext.getCurrent());
            this.loginForRunAs();
            invocation.setPreInvokeDone(true);
        }
    }

    public Object invoke(final Method beanClassMethod, boolean isLocal, final Object bean, final Object[] methodParameters) throws Throwable {
        if (isLocal && this.getUsesCallerIdentity() || System.getSecurityManager() == null) {
            return this.authorizationService.invokeBeanMethod(bean, beanClassMethod, methodParameters);
        }
        PrivilegedExceptionAction<Object> pea = new PrivilegedExceptionAction<Object>(this){

            @Override
            public Object run() throws Exception {
                return beanClassMethod.invoke(bean, methodParameters);
            }
        };
        try {
            return this.doAsPrivileged(pea);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getCause();
        }
    }

    public void postInvoke(final ComponentInvocation invocation) {
        if (this.runAs != null && invocation.isPreInvokeDone()) {
            AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(this){

                @Override
                public Object run() {
                    SecurityContext.setCurrent((SecurityContext)((SecurityContext)invocation.getOldSecurityContext()));
                    return null;
                }
            });
        }
    }

    public Subject getCurrentSubject() {
        return SecurityContext.getCurrent().getSubject();
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return SecurityContext.getDefaultCallerPrincipal();
        }
        return securityContext.getCallerPrincipal();
    }

    public void destroy() {
        try {
            this.authorizationService.refresh();
            PermissionCacheFactory.removePermissionCache((PermissionCache)this.uncheckedMethodPermissionCache);
            this.uncheckedMethodPermissionCache = null;
            this.roleMapperFactory.removeAppNameForContext(this.contextId);
        }
        catch (IllegalStateException e) {
            _logger.log(Level.WARNING, "ejbsm.could_not_delete", e);
        }
        this.probeProvider.securityManagerDestructionStartedEvent(this.ejbName);
        this.ejbSecurityManagerFactory.getManager(this.contextId, this.ejbName, true);
        this.probeProvider.securityManagerDestructionEndedEvent(this.ejbName);
        this.probeProvider.securityManagerDestructionEvent(this.ejbName);
    }

    public Object doAsPrivileged(PrivilegedExceptionAction<Object> privilegedAction) throws Throwable {
        AccessControlContext accessControlContext = this.getCachedAccessControlContext(SecurityContext.getCurrent());
        return this.authorizationService.runInScope(() -> AccessController.doPrivileged(privilegedAction, accessControlContext));
    }

    private boolean getUsesCallerIdentity() {
        return this.runAs == null;
    }

    private static CodeSource getApplicationCodeSource(String contextId) throws Exception {
        CodeSource result = null;
        String archiveURI = "file:///" + contextId.replace(' ', '_');
        try {
            URI uri = null;
            try {
                uri = new URI(archiveURI);
                if (uri != null) {
                    result = new CodeSource(uri.toURL(), (Certificate[])null);
                }
            }
            catch (URISyntaxException use) {
                _logger.log(Level.SEVERE, "JACC_createurierror", use);
                throw new RuntimeException(use);
            }
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.SEVERE, "JACC_ejbsm.codesourceerror", mue);
            throw new RuntimeException(mue);
        }
        return result;
    }

    private ProtectionDomain getCachedProtectionDomain(Set<Principal> principalSet, boolean useApplicationCodeSource) {
        ProtectionDomain protectionDomain = null;
        Principal[] principals = null;
        CodeSource currentCodeSource = null;
        if (useApplicationCodeSource) {
            protectionDomain = this.applicationProtectionDomainCache.get(principalSet);
            currentCodeSource = this.applicationCodeSource;
        } else {
            protectionDomain = this.managerProtectionDomainCache.get(principalSet);
            currentCodeSource = managerCodeSource;
        }
        if (protectionDomain == null) {
            HashSet<Principal> newKeySet;
            principals = principalSet == null ? null : principalSet.toArray(new Principal[principalSet.size()]);
            protectionDomain = new ProtectionDomain(currentCodeSource, null, null, principals);
            HashSet<Principal> hashSet = newKeySet = principalSet != null ? new HashSet<Principal>(principalSet) : new HashSet();
            if (useApplicationCodeSource) {
                this.applicationProtectionDomainCache.put(newKeySet, protectionDomain);
            } else {
                this.managerProtectionDomainCache.put(newKeySet, protectionDomain);
            }
            _logger.fine(() -> "Authorization: new ProtectionDomain added to cache");
        }
        if (_logger.isLoggable(Level.FINE)) {
            if (principalSet == null) {
                _logger.fine("Authorization: returning cached ProtectionDomain PrincipalSet: null");
            } else {
                StringBuilder principalBuilder = null;
                principals = principalSet.toArray(new Principal[principalSet.size()]);
                for (int i = 0; i < principals.length; ++i) {
                    if (i == 0) {
                        principalBuilder = new StringBuilder(principals[i].toString());
                        continue;
                    }
                    principalBuilder.append(" " + principals[i].toString());
                }
                _logger.fine("Authorization: returning cached ProtectionDomain - CodeSource: (" + String.valueOf(currentCodeSource) + ") PrincipalSet: " + String.valueOf(principalBuilder));
            }
        }
        return protectionDomain;
    }

    private AccessControlContext getCachedAccessControlContext(SecurityContext securityContext) throws Exception {
        Set principalSet = securityContext.getPrincipalSet();
        AccessControlContext accessControlContext = this.accessControlContextCache.get(principalSet);
        if (accessControlContext == null) {
            final ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{this.getCachedProtectionDomain(principalSet, false)};
            try {
                if (principalSet != null) {
                    final Subject subject = securityContext.getSubject();
                    accessControlContext = AccessController.doPrivileged(new PrivilegedExceptionAction<AccessControlContext>(this){

                        @Override
                        public AccessControlContext run() throws Exception {
                            return new AccessControlContext(new AccessControlContext(protectionDomainArray), new SubjectDomainCombiner(subject));
                        }
                    });
                } else {
                    accessControlContext = new AccessControlContext(protectionDomainArray);
                }
                if (principalSet != null) {
                    this.accessControlContextCache.put(new HashSet(principalSet), accessControlContext);
                }
                _logger.fine("Authorization: new AccessControlContext added to cache");
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.security_context_exception", e);
                accessControlContext = null;
                throw e;
            }
        }
        return accessControlContext;
    }

    private void loginForRunAs() {
        AppservAccessController.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LoginContextDriver.loginPrincipal((String)EJBSecurityManager.this.runAs.getPrincipal(), (String)EJBSecurityManager.this.realmName);
                return null;
            }
        });
    }

    public void resetPolicyContext() {
        PolicyContext.setContextID(null);
    }

    private SecurityContext getSecurityContext() {
        if (this.runAs == null) {
            return SecurityContext.getCurrent();
        }
        ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new InvocationException();
        }
        return (SecurityContext)componentInvocation.getOldSecurityContext();
    }

    private String getRealmName(EjbDescriptor deploymentDescriptor) {
        String realmName = deploymentDescriptor.getApplication().getRealm();
        if (realmName == null) {
            for (EjbIORConfigurationDescriptor iorConfig : deploymentDescriptor.getIORConfigurationDescriptors()) {
                realmName = iorConfig.getRealmName();
            }
        }
        return realmName;
    }

    private RunAsIdentityDescriptor getRunAs(EjbDescriptor deploymentDescriptor) {
        if (deploymentDescriptor.getUsesCallerIdentity().booleanValue()) {
            return null;
        }
        RunAsIdentityDescriptor runAs = deploymentDescriptor.getRunAsIdentity();
        if (runAs != null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, deploymentDescriptor.getEjbClassName() + " will run-as: " + runAs.getPrincipal() + " (" + runAs.getRoleName() + ")");
        }
        return runAs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEnterpriseBeansStatsProvider() {
        if (ejbStatsProvider != null) return;
        Class<EjbSecurityStatsProvider> clazz = EjbSecurityStatsProvider.class;
        synchronized (EjbSecurityStatsProvider.class) {
            if (ejbStatsProvider != null) return;
            ejbStatsProvider = new EjbSecurityStatsProvider();
            StatsProviderManager.register((String)"security", (PluginPoint)PluginPoint.SERVER, (String)"security/ejb", (Object)ejbStatsProvider);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void doAuditAuthorize(SecurityContext securityContext, EjbInvocation ejbInvocation, boolean authorized) {
        if (this.auditManager.isAuditOn()) {
            String caller = securityContext.getCallerPrincipal().getName();
            this.auditManager.ejbInvocation(caller, this.ejbName, ejbInvocation.method.toString(), authorized);
            _logger.fine(() -> " (Caller) = " + caller);
        }
    }
}

