/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.persistent.timer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.FinderException;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.TransactionManager;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.persistent.timer.TimerLocal;
import org.glassfish.ejb.persistent.timer.TimerState;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class PersistentEJBTimerService
extends EJBTimerService {
    private final TimerLocal timerLocal_;
    private static final Logger logger = LogDomains.getLogger(PersistentEJBTimerService.class, (String)"jakarta.enterprise.system.container.ejb");
    private boolean performDBReadBeforeTimeout;
    private final boolean removeOldTimers;
    private static final String strDBReadBeforeTimeout = "com.sun.ejb.timer.ReadDBBeforeTimeout";
    private boolean foundSysPropDBReadBeforeTimeout;
    EjbTimerService ejbt;
    private DataSource timerDataSource;
    private static final SimpleJndiName TIMER_RESOURCE_JNDI = new SimpleJndiName("jdbc/__TimerPool");
    private static final String TIMER_SERVICE_APP_NAME = "ejb-timer-service-app";
    private static final String TIMER_SERVICE_BEAN_NAME = "TimerBean";
    private static final String ON_CONECTION_FAILURE = "operation-on-connection-failure";
    private static final String OP_REDELIVER = "redeliver";
    private static final String OP_STOP = "stop";
    private String operationOnConnectionFailure;

    private PersistentEJBTimerService(String ejbName, boolean removeOldTimers) throws Exception {
        this.timerLocal_ = (TimerLocal)this.ejbContainerUtil.getGlassfishNamingManager().getInitialContext().lookup(ejbName);
        this.removeOldTimers = removeOldTimers;
        this.initProperties();
        this.lookupTimerResource();
        this.setPerformDBReadBeforeTimeout(!this.isDas);
    }

    private void initProperties() {
        try {
            EjbContainer ejbc = this.ejbContainerUtil.getEjbContainer();
            this.ejbt = ejbc.getEjbTimerService();
            if (this.ejbt != null) {
                this.foundSysPropDBReadBeforeTimeout = this.getDBReadBeforeTimeoutProperty();
                this.operationOnConnectionFailure = this.ejbt.getPropertyValue(ON_CONECTION_FAILURE);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
    }

    public String[] listTimers(String[] serverIds) {
        String[] totalTimers = null;
        try {
            totalTimers = this.timerLocal_.countTimersOwnedByServerIds(serverIds);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception in listTimers() : ", ex);
            EJBException ejbEx = this.createEJBException(ex);
            throw ejbEx;
        }
        return totalTimers;
    }

    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from an active server instance " + ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from  an active server instance " + ownerIdOfThisServer);
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner " + fromOwnerId + " to " + ownerIdOfThisServer);
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        Set toRestore = null;
        int totalTimersMigrated = 0;
        try {
            tm.begin();
            toRestore = this.timerLocal_.findTimersOwnedBy(fromOwnerId);
            totalTimersMigrated = this.timerLocal_.migrateTimers(fromOwnerId, ownerIdOfThisServer);
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "timer migration error", e);
            try {
                tm.rollback();
            }
            catch (Exception re) {
                logger.log(Level.FINE, "timer migration rollback error", re);
            }
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        if (totalTimersMigrated > 0) {
            boolean success = false;
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of " + toRestore.size() + " timers.  Now reactivating timers...");
                this._notifyContainers(toRestore);
                tm.begin();
                this._restoreTimers(toRestore);
                success = true;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "timer restoration error", e);
                EJBException ejbEx = this.createEJBException(e);
                throw ejbEx;
            }
            finally {
                block15: {
                    try {
                        tm.commit();
                    }
                    catch (Exception re) {
                        logger.log(Level.FINE, "timer migration error", re);
                        if (!success) break block15;
                        EJBException ejbEx = this.createEJBException(re);
                        throw ejbEx;
                    }
                }
            }
        }
        logger.log(Level.INFO, fromOwnerId + " has 0 timers in need of migration");
        return totalTimersMigrated;
    }

    public boolean isPersistent() {
        return true;
    }

    private void setPerformDBReadBeforeTimeout(boolean defaultDBReadValue) {
        if (!this.foundSysPropDBReadBeforeTimeout) {
            this.performDBReadBeforeTimeout = defaultDBReadValue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
            }
        }
    }

    private boolean getDBReadBeforeTimeoutProperty() {
        boolean result = false;
        try {
            String str = System.getProperty(strDBReadBeforeTimeout);
            if (null != str) {
                this.performDBReadBeforeTimeout = Boolean.valueOf(str);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
                }
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "getDBReadBeforeTimeoutProperty(),  Exception when trying to get the System property - ", e);
        }
        return result;
    }

    private boolean restoreEJBTimers() {
        boolean rc = false;
        try {
            if (this.totalTimedObjectsInitialized_ > 0L) {
                this.restoreTimers();
                rc = true;
            } else {
                int s = this.timerLocal_.findActiveTimersOwnedByThisServer().size();
                if (s > 0) {
                    logger.log(Level.INFO, "[" + s + "] EJB Timers owned by this server will be restored when timeout beans are loaded");
                } else {
                    logger.log(Level.INFO, "There are no EJB Timers owned by this server");
                }
                rc = true;
            }
        }
        catch (Exception ex) {
            EJBTimerService.setEJBTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", ex);
        }
        return rc;
    }

    private void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServer());
        }
        finally {
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            }
        }
    }

    private void _notifyContainers(Set<TimerState> timers) {
        for (TimerState timer : timers) {
            EJBTimerSchedule ts = timer.getTimerSchedule();
            if (ts == null || !ts.isAutomatic()) continue;
            this.addToSchedules(timer.getContainerId(), this.getPrimaryKey(timer), ts);
        }
    }

    private Set<TimerState> _restoreTimers(Set<TimerState> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<TimerState> result = new HashSet<TimerState>();
        for (TimerState timerState : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = this.getPrimaryKey(timerState);
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: " + String.valueOf(timerState));
                result.add(timerState);
                continue;
            }
            long containerId = timerState.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = timerState.getApplicationId();
                if (appid == 0L) {
                    timerState.setApplicationId(container.getApplicationId());
                }
                Date initialExpiration = timerState.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.getContainerInfo().type == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = timerState.getTimedObjectPrimaryKey();
                }
                RuntimeTimerState timerState2 = new RuntimeTimerState(timerId, initialExpiration, timerState.getIntervalDuration(), container, timedObjectPrimaryKey, timerState.getTimerSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState2);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState2.isPeriodic()) {
                    Date lastExpiration = timerState.getLastExpiration();
                    EJBTimerSchedule ts = timerState.getTimerSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState2.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + String.valueOf(timerState2) + ". Timer expirations should  have been delivered starting at " + String.valueOf(initialExpiration));
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > timerState.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + String.valueOf(timerState2) + ".  Last timer expiration occurred at " + String.valueOf(lastExpiration));
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState2);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + String.valueOf(timerState2) + ". Timer expiration should  have been delivered at " + String.valueOf(initialExpiration));
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer " + String.valueOf(timerState2) + " that will never expire again");
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState2, expirationTime);
                result.add(timerState);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer " + String.valueOf(timerId) + " for container that is not up: " + containerId);
        }
        if (timerIdsToRemove.size() > 0) {
            this.timerLocal_.remove(timerIdsToRemove);
        }
        for (Object object : timersToRestore.entrySet()) {
            Map.Entry next = (Map.Entry)object;
            RuntimeTimerState nextTimer = (RuntimeTimerState)next.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)next.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + String.valueOf(nextTimer));
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    protected void cancelTimersByKey(long containerId, Object primaryKey) {
        try {
            Collection<TimerState> timers = this.getTimers(containerId, primaryKey);
            if (logger.isLoggable(Level.FINE) && timers.isEmpty()) {
                logger.log(Level.FINE, "0 cancelEntityBeanTimers for " + containerId + ", " + String.valueOf(primaryKey));
            }
            this.timerLocal_.cancelTimers(timers);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.cancel_entity_timers", new Object[]{String.valueOf(containerId), primaryKey});
            logger.log(Level.WARNING, "", e);
        }
    }

    protected void stopTimers(long containerId) {
        super.stopTimers(containerId);
        this.stopTimers(this.timerLocal_.findTimerIdsByContainer(containerId));
    }

    protected void _destroyTimers(long id, boolean all) {
        int count;
        int n = count = all ? this.timerLocal_.countTimersByApplication(id) : this.timerLocal_.countTimersByContainer(id);
        if (count == 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: " + id);
            }
            return;
        }
        try {
            int deleted;
            int n2 = deleted = all ? this.timerLocal_.deleteTimersByApplication(id) : this.timerLocal_.deleteTimersByContainer(id);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "[" + deleted + "] timers deleted for id: " + id);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(id)});
            logger.log(Level.WARNING, "", ex);
        }
    }

    protected void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        try {
            if (timerConfig.isPersistent()) {
                this.timerLocal_.createTimer(timerId.getTimerId(), containerId, applicationId, server_name, timedObjectPrimaryKey, initialExpiration, intervalDuration, schedule, timerConfig);
            } else {
                this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{String.valueOf(containerId), timedObjectPrimaryKey, timerConfig.getInfo()});
            logger.log(Level.SEVERE, "", e);
            this.timerCache_.removeTimer(timerId);
            if (e instanceof CreateException) {
                throw (CreateException)((Object)e);
            }
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)e);
            throw ejbEx;
        }
    }

    protected Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            Set<TimerState> timers = this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServerByContainer(containerId));
            if (timers.size() > 0) {
                logger.log(Level.FINE, "Found " + timers.size() + " persistent timers for containerId: " + containerId);
            }
            boolean schedulesExist = schedules.size() > 0;
            for (TimerState timer : timers) {
                EJBTimerSchedule ts = timer.getTimerSchedule();
                if (ts == null || !ts.isAutomatic() || !schedulesExist) continue;
                for (Map.Entry<Method, List<ScheduledTimerDescriptor>> entry : schedules.entrySet()) {
                    Method m = entry.getKey();
                    if (!m.getName().equals(ts.getTimerMethodName()) || m.getParameterTypes().length != ts.getMethodParamCount()) continue;
                    result.put(new TimerPrimaryKey(timer.getTimerId()), m);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "@@@ FOUND existing schedule: " + ts.getScheduleAsString() + " FOR method: " + String.valueOf(m));
                }
            }
            this.createSchedules(containerId, applicationId, schedules, result, this.ownerIdOfThisServer_, true, deploy && this.isDas);
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, (TransactionManager)tm);
        }
        return result;
    }

    public void createSchedulesOnServer(EjbDescriptor ejbDescriptor, String server_name) {
        HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>> schedules = new HashMap<MethodDescriptor, List<ScheduledTimerDescriptor>>();
        for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
            ArrayList<ScheduledTimerDescriptor> list;
            MethodDescriptor method = schd.getTimeoutMethod();
            if (method == null || !schd.getPersistent()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "... processing " + String.valueOf(method));
            }
            if ((list = (ArrayList<ScheduledTimerDescriptor>)schedules.get(method)) == null) {
                list = new ArrayList<ScheduledTimerDescriptor>();
                schedules.put(method, list);
            }
            list.add(schd);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - creating schedules for " + ejbDescriptor.getUniqueId());
        }
        this.createSchedules(ejbDescriptor.getUniqueId(), ejbDescriptor.getApplication().getUniqueId(), schedules, server_name);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "EJBTimerService - finished processing schedules for BEAN ID: " + ejbDescriptor.getUniqueId());
        }
    }

    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            int count = this.timerLocal_.countTimersByContainer(containerId);
            if (count == 0) {
                this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
            }
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, (TransactionManager)tm);
        }
    }

    private void recoverAndCreateSchedulesError(Exception e, TransactionManager tm) {
        logger.log(Level.WARNING, "Timer restore or schedule creation error", e);
        try {
            tm.rollback();
        }
        catch (Exception re) {
            logger.log(Level.FINE, "Timer restore or schedule creation rollback error", re);
        }
        EJBException ejbEx = this.createEJBException(e);
        throw ejbEx;
    }

    private Collection<TimerState> getTimers(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerState> activeTimers;
        HashSet<TimerState> timersForTimedObject = activeTimers = this.timerLocal_.findActiveTimersByContainer(containerId);
        if (timedObjectPrimaryKey != null) {
            timersForTimedObject = new HashSet<TimerState>();
            for (TimerState timer : activeTimers) {
                Object nextTimedObjectPrimaryKey = timer.getTimedObjectPrimaryKey();
                if (!nextTimedObjectPrimaryKey.equals(timedObjectPrimaryKey)) continue;
                timersForTimedObject.add(timer);
            }
        }
        return timersForTimedObject;
    }

    protected Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        Set<TimerPrimaryKey> timerIdsForTimedObject = new HashSet();
        if (timedObjectPrimaryKey == null) {
            timerIdsForTimedObject = this.timerLocal_.findActiveTimerIdsByContainer(containerId);
        } else {
            Collection<TimerState> timersForTimedObject = this.getTimers(containerId, timedObjectPrimaryKey);
            for (TimerState timer : timersForTimedObject) {
                timerIdsForTimedObject.add(this.getPrimaryKey(timer));
            }
        }
        timerIdsForTimedObject.addAll(super.getTimerIds(containerId, null));
        return timerIdsForTimedObject;
    }

    protected Collection<TimerPrimaryKey> getTimerIds(Collection<Long> containerIds) {
        HashSet<TimerPrimaryKey> timerIds = new HashSet<TimerPrimaryKey>(super.getTimerIds(containerIds));
        timerIds.addAll(this.timerLocal_.findActiveTimerIdsByContainers(containerIds));
        return timerIds;
    }

    protected void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        if (!this.cancelNonPersistentTimer(timerId)) {
            this.timerLocal_.cancel(timerId);
        }
    }

    private TimerPrimaryKey getPrimaryKey(TimerState timer) {
        return new TimerPrimaryKey(timer.getTimerId());
    }

    protected Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        TimerState timer = this.getPersistentTimer(timerId);
        Date initialExpiration = timer.getInitialExpiration();
        long intervalDuration = timer.getIntervalDuration();
        EJBTimerSchedule ts = timer.getTimerSchedule();
        Date nextTimeout = null;
        nextTimeout = ts != null ? this.getNextScheduledTimeout(ts) : (intervalDuration > 0L ? this.calcNextFixedRateExpiration(initialExpiration, intervalDuration) : initialExpiration);
        return nextTimeout;
    }

    protected Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return super.getInfo(timerId);
        }
        TimerState timer = this.getPersistentTimer(timerId);
        return timer.getInfo();
    }

    protected boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return false;
        }
        this.getPersistentTimer(timerId);
        return true;
    }

    protected boolean timerExists(TimerPrimaryKey timerId) {
        TimerState timer;
        boolean exists = super.timerExists(timerId);
        if (!exists && (timer = this.timerLocal_.findTimer(timerId)) != null) {
            exists = timer.isActive();
        }
        return exists;
    }

    protected EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        if (!super.isPersistent(timerId)) {
            ts = super.getTimerSchedule(timerId);
        } else {
            TimerState timer = this.getPersistentTimer(timerId);
            ts = timer.getTimerSchedule();
        }
        return ts;
    }

    private void removeTimerBean(TimerPrimaryKey timerId) {
        try {
            this.timerLocal_.remove(timerId);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "ejb.remove_timer_failure", new Object[]{timerId});
            logger.log(Level.WARNING, "", t);
        }
    }

    private TimerState getPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        TimerState timer = this.timerLocal_.findTimer(timerId);
        if (timer == null || timer.isCancelled()) {
            throw new FinderException("timer " + String.valueOf(timerId) + " does not exist");
        }
        return timer;
    }

    protected boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        if (timerState.isPersistent() && this.performDBReadBeforeTimeout) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "For Timer :" + String.valueOf(timerState.getTimerId()) + ": check the database to ensure that the timer is still  valid, before delivering the ejbTimeout call");
            }
            if (!this.checkForTimerValidity(timerState.getTimerId())) {
                return true;
            }
        }
        return false;
    }

    protected boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries() || this.redeliverOnFailedConnection();
    }

    protected boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        return !timerState.isPersistent() || this.getValidTimerFromDB(timerId) != null;
    }

    protected void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        if (timerState.isPersistent()) {
            TimerState timer = this.getValidTimerFromDB(timerId);
            if (null == timer) {
                return;
            }
            Date now = new Date();
            timer.setLastExpiration(now);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting last expiration  for periodic timer " + String.valueOf(timerState) + " to " + String.valueOf(now));
            }
        }
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.getValidTimerFromDB(timerId);
        if (null == timer) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerState getValidTimerFromDB(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.timerLocal_.findTimer(timerId);
        try {
            if (timer != null) {
                if (!timer.getOwnerId().equals(this.ownerIdOfThisServer_)) {
                    logger.log(Level.WARNING, "The timer (" + String.valueOf(timerId) + ") is not owned by server (" + this.ownerIdOfThisServer_ + ") that initiated the ejbTimeout. This timer is now owned by (" + timer.getOwnerId() + "). \nHence delete the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                    result = false;
                }
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Timer :" + String.valueOf(timerId) + ": has been cancelled by another server instance. Expunging the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                }
                result = false;
            }
        }
        finally {
            if (!result) {
                this.expungeTimer(timerId, false);
                timer = null;
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Timer :" + String.valueOf(timerId) + ": is a valid timer for the server (" + this.ownerIdOfThisServer_ + ")");
            }
        }
        return timer;
    }

    protected void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        if (removeTimerBean) {
            this.removeTimerBean(timerId);
        }
        super.expungeTimer(timerId, removeTimerBean);
    }

    TimerLocal getTimerLocal() {
        return this.timerLocal_;
    }

    protected boolean stopOnFailure() {
        return this.stopOnFailedConnection();
    }

    private boolean redeliverOnFailedConnection() {
        return this.operationOnConnectionFailure != null && this.operationOnConnectionFailure.equalsIgnoreCase(OP_REDELIVER) && this.failedConnection();
    }

    private boolean stopOnFailedConnection() {
        return this.operationOnConnectionFailure != null && this.operationOnConnectionFailure.equalsIgnoreCase(OP_STOP) && this.failedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean failedConnection() {
        boolean failed = false;
        Connection c = null;
        try {
            if (this.timerDataSource == null) {
                this.lookupTimerResource();
            }
            failed = !(c = this.timerDataSource.getConnection()).isValid(0);
        }
        catch (Exception e) {
            failed = true;
        }
        finally {
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception exception) {}
        }
        if (failed) {
            logger.log(Level.WARNING, "Cannot acquire a connection from the database used by the EJB Timer Service");
        } else {
            logger.log(Level.FINE, "Connection ok");
        }
        return failed;
    }

    private void lookupTimerResource() throws Exception {
        SimpleJndiName resource_name = this.getTimerResource();
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.ejbContainerUtil.getServices().getService(ConnectorRuntime.class, new Annotation[0]);
        this.timerDataSource = (DataSource)DataSource.class.cast(connectorRuntime.lookupNonTxResource(resource_name, false));
    }

    static void initEJBTimerService(String target) {
        PersistentEJBTimerService ts = null;
        EjbContainerUtil _ejbContainerUtil = EjbContainerUtilImpl.getInstance();
        EjbTimerService _ejbt = _ejbContainerUtil.getEjbTimerService(target);
        SimpleJndiName resourceName = PersistentEJBTimerService.getTimerResource(_ejbt);
        File root = _ejbContainerUtil.getServerContext().getInstallRoot();
        boolean is_upgrade = PersistentEJBTimerService.isUpgrade(resourceName, _ejbt, root);
        File rootScratchDir = _ejbContainerUtil.getServerEnvironment().getApplicationStubPath();
        File appScratchFile = new File(rootScratchDir, TIMER_SERVICE_APP_NAME);
        boolean removeOldTimers = is_upgrade && !appScratchFile.exists();
        boolean available = _ejbContainerUtil.getDeployment().isRegistered(TIMER_SERVICE_APP_NAME);
        if (available) {
            logger.log(Level.WARNING, "EJBTimerService had been explicitly deployed.");
        } else if (resourceName != null) {
            available = PersistentEJBTimerService.deployEJBTimerService(root, appScratchFile, resourceName, is_upgrade);
        } else {
            logger.log(Level.WARNING, "Cannot deploy EJBTimerService: Timer resource for target " + target + " is not available");
        }
        if (available) {
            try {
                ts = new PersistentEJBTimerService("java:global/ejb-timer-service-app/TimerBean", removeOldTimers);
                logger.log(Level.INFO, "ejb.timer_service_started", resourceName);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", ex);
            }
        }
        EJBTimerService.setEJBTimerService(ts);
    }

    protected void resetEJBTimers(String target) {
        if (this.removeOldTimers) {
            this.destroyAllTimers(0L);
        } else if (target == null) {
            logger.log(Level.INFO, "==> Restoring Timers ... ");
            if (this.restoreEJBTimers()) {
                logger.log(Level.INFO, "<== ... Timers Restored.");
            }
        }
    }

    private SimpleJndiName getTimerResource() {
        return PersistentEJBTimerService.getTimerResource(this.ejbt);
    }

    private static SimpleJndiName getTimerResource(EjbTimerService _ejbt) {
        SimpleJndiName resource = null;
        if (_ejbt != null) {
            if (_ejbt.getTimerDatasource() == null) {
                resource = TIMER_RESOURCE_JNDI;
            } else {
                return new SimpleJndiName(_ejbt.getTimerDatasource());
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deployEJBTimerService(File root, File appScratchFile, SimpleJndiName resourceName, boolean is_upgrade) {
        boolean deployed = false;
        logger.log(Level.INFO, "Loading EJBTimerService. Please wait.");
        File app = null;
        try {
            app = FileUtils.getManagedFile((String)"ejb-timer-service-app.war", (File)new File(root, "lib/install/applications/"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Caught unexpected exception", e);
        }
        if (app == null || !app.exists()) {
            logger.log(Level.WARNING, "Cannot deploy or load persistent EJBTimerService: required WAR file (ejb-timer-service-app.war) is not installed");
        } else {
            DeployCommandParameters params = new DeployCommandParameters(app);
            params.name = TIMER_SERVICE_APP_NAME;
            try {
                EjbContainerUtil _ejbContainerUtil = EjbContainerUtilImpl.getInstance();
                params.origin = _ejbContainerUtil.isDas() && appScratchFile.createNewFile() && !is_upgrade ? OpsParams.Origin.deploy : OpsParams.Origin.load;
                params.target = _ejbContainerUtil.getServerEnvironment().getInstanceName();
                ActionReport report = (ActionReport)_ejbContainerUtil.getServices().getService(ActionReport.class, "plain", new Annotation[0]);
                Deployment deployment = _ejbContainerUtil.getDeployment();
                ExtendedDeploymentContext dc = deployment.getBuilder(logger, (OpsParams)params, report).source(app).build();
                dc.addTransientAppMetaData("org.glassfish.jta.datasource.jndi.name", (Object)resourceName);
                Properties appProps = dc.getAppProps();
                appProps.setProperty("object-type", "system-all");
                deployment.deploy(dc);
                if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                    logger.log(Level.WARNING, "Cannot deploy or load EJBTimerService: ", report.getFailureCause());
                } else {
                    deployed = true;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot deploy or load EJBTimerService: ", e);
            }
            finally {
                if (!deployed && params.origin.isDeploy() && appScratchFile.exists() && !appScratchFile.delete()) {
                    logger.log(Level.WARNING, "Failed to remove the marker file " + String.valueOf(appScratchFile));
                }
            }
        }
        return deployed;
    }

    private static boolean isUpgrade(SimpleJndiName resource, EjbTimerService _ejbt, File root) {
        List properties;
        boolean upgrade = false;
        Property prop = null;
        if (_ejbt != null && (properties = _ejbt.getProperty()) != null) {
            for (Property p : properties) {
                String value;
                if (!p.getName().equals("ejb-timer-service-upgraded") || (value = p.getValue()) == null || !"false".equals(value)) continue;
                upgrade = true;
                prop = p;
                break;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("===> Upgrade? <==");
        }
        if (upgrade) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("===> Upgrade! <==");
            }
            boolean success = false;
            try {
                File dir = new File(root, "lib/install/databases/upgrade");
                if (!dir.exists()) {
                    logger.log(Level.WARNING, "Cannot upgrade EJBTimerService: required directory is not available");
                } else {
                    Java2DBProcessorHelper h = new Java2DBProcessorHelper(TIMER_SERVICE_APP_NAME);
                    success = h.executeDDLStatement(dir.getCanonicalPath() + "/ejbtimer_upgrade_", resource);
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                        public Object run(Property p) throws PropertyVetoException, TransactionFailure {
                            p.setValue("true");
                            return null;
                        }
                    }, (ConfigBeanProxy)prop);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "", e);
            }
            if (!success) {
                logger.log(Level.SEVERE, "Failed to upgrade EJBTimerService: see log for details");
            }
        }
        return upgrade;
    }
}

