/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb;

import java.io.IOException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.ejb.EjbSniffer;
import org.glassfish.ejb.EjbType;
import org.glassfish.hk2.Services;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service(name="ejb")
@Scoped(value=Singleton.class)
public class EjbJarDetector
implements ArchiveDetector {
    public static final String EJB_JAR_DETECTOR_RANK_PROP = "glassfish.ejb.jar.detector.rank";
    public static final int DEFAULT_EJB_JAR_DETECTOR_RANK = 400;
    public static final String ARCHIVE_TYPE = "ejb";
    @Inject
    private EjbSniffer sniffer;
    @Inject
    private EjbType archiveType;
    @Inject
    private Services services;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public int rank() {
        return Integer.getInteger(EJB_JAR_DETECTOR_RANK_PROP, 400);
    }

    public boolean handles(ReadableArchive archive) {
        return DeploymentUtils.isEjbJar((ReadableArchive)archive, (Habitat)((Habitat)this.services.byType(Habitat.class).get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        EjbJarDetector ejbJarDetector = this;
        synchronized (ejbJarDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.services.forContract(ArchiveHandler.class).named(ARCHIVE_TYPE).get();
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }
}

