/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class DropSequenceNode
extends DDLStatementNode {
    private TableName dropItem;

    public void init(Object object) throws StandardException {
        this.dropItem = (TableName)object;
        this.initAndCheck(this.dropItem);
    }

    public String statementToString() {
        return "DROP ".concat(this.dropItem.getTableName());
    }

    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = this.getRelativeName();
        SequenceDescriptor sequenceDescriptor = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            sequenceDescriptor = dataDictionary.getSequenceDescriptor(schemaDescriptor, string);
        }
        if (sequenceDescriptor == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)string);
        }
        this.getCompilerContext().createDependency(sequenceDescriptor);
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSequenceConstantAction(this.getSchemaDescriptor(), this.getRelativeName());
    }
}

