/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.raw.data.RecordId;

public class HeapRowLocation
extends DataType
implements RowLocation {
    private long pageno;
    private int recid;
    private RecordHandle rh;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(HeapRowLocation.class);
    private static final int RECORD_HANDLE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(RecordId.class);

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.rh) {
            n += RECORD_HANDLE_MEMORY_USAGE;
        }
        return n;
    }

    public String getTypeName() {
        return "RowLocation";
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) {
    }

    public DataValueDescriptor getNewNull() {
        return new HeapRowLocation();
    }

    public Object getObject() {
        return null;
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new HeapRowLocation(this);
    }

    public DataValueDescriptor recycle() {
        this.pageno = 0L;
        this.recid = 0;
        this.rh = null;
        return this;
    }

    public int getLength() {
        return 10;
    }

    public String getString() {
        return this.toString();
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) {
        int n2 = this.compare(dataValueDescriptor);
        switch (n) {
            case 1: {
                return n2 < 0;
            }
            case 2: {
                return n2 == 0;
            }
            case 3: {
                return n2 <= 0;
            }
        }
        return false;
    }

    public int compare(DataValueDescriptor dataValueDescriptor) {
        HeapRowLocation heapRowLocation = (HeapRowLocation)dataValueDescriptor;
        long l = this.pageno;
        long l2 = heapRowLocation.pageno;
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        int n = this.recid;
        int n2 = heapRowLocation.recid;
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    HeapRowLocation(RecordHandle recordHandle) {
        this.setFrom(recordHandle);
    }

    public HeapRowLocation() {
        this.pageno = 0L;
        this.recid = 0;
    }

    private HeapRowLocation(HeapRowLocation heapRowLocation) {
        this.pageno = heapRowLocation.pageno;
        this.recid = heapRowLocation.recid;
        this.rh = heapRowLocation.rh;
    }

    public RecordHandle getRecordHandle(ContainerHandle containerHandle) throws StandardException {
        if (this.rh != null) {
            return this.rh;
        }
        this.rh = containerHandle.makeRecordHandle(this.pageno, this.recid);
        return this.rh;
    }

    void setFrom(RecordHandle recordHandle) {
        this.pageno = recordHandle.getPageNumber();
        this.recid = recordHandle.getId();
        this.rh = recordHandle;
    }

    public int getTypeFormatId() {
        return 90;
    }

    public boolean isNull() {
        return false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeLong(objectOutput, this.pageno);
        CompressedNumber.writeInt(objectOutput, this.recid);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pageno = CompressedNumber.readLong(objectInput);
        this.recid = CompressedNumber.readInt(objectInput);
        this.rh = null;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException, ClassNotFoundException {
        this.pageno = arrayInputStream.readCompressedLong();
        this.recid = arrayInputStream.readCompressedInt();
        this.rh = null;
    }

    public void restoreToNull() {
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) {
        HeapRowLocation heapRowLocation = (HeapRowLocation)dataValueDescriptor;
        this.pageno = heapRowLocation.pageno;
        this.recid = heapRowLocation.recid;
        this.rh = heapRowLocation.rh;
    }

    public boolean equals(Object object) {
        if (object instanceof HeapRowLocation) {
            HeapRowLocation heapRowLocation = (HeapRowLocation)object;
            return this.pageno == heapRowLocation.pageno && this.recid == heapRowLocation.recid;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.pageno ^ this.recid;
    }

    public String toString() {
        String string = "(" + this.pageno + "," + this.recid + ")";
        return string;
    }
}

