/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;

public class HAClusterManagerImpl
extends ClusterManagerImpl
implements ClusterManager {
    private static boolean IGNORE_HADB_ERRORS = true;
    private String localBrokerId = null;
    private int VERSION = 40;
    protected UID localSessionUID = null;

    public boolean isHA() {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        return true;
    }

    public void reloadConfig() throws BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String[] stringArray = new String[]{"imq.cluster.url"};
        this.config.reloadProps(Globals.getConfigName(), stringArray, false);
    }

    protected Map getAllBrokers() throws BrokerException {
        return new HAMap();
    }

    public String initialize(MQAddress mQAddress) throws BrokerException {
        Store store;
        this.logger.log(4, "initializingCluster at " + mQAddress);
        this.localBrokerId = Globals.getBrokerID();
        if (this.localBrokerId == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3093", "null"));
        }
        String string = this.config.getProperty("imq.cluster.masterbroker");
        if (string != null) {
            this.logger.log(16, Globals.getBrokerResources().getKString("B2194", "imq.cluster.masterbroker=" + string));
        }
        if (!(store = Globals.getStore()).isJDBCStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3221"));
        }
        super.initialize(mQAddress);
        return this.localBrokerId;
    }

    protected boolean allowMasterBroker() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedHashSet parseBrokerList() throws MalformedURLException {
        String string = this.config.getProperty("imq.cluster.brokerlist");
        String string2 = this.config.getProperty("imq.cluster.brokerlist.manual");
        if (string != null) {
            this.logger.log(8, "B1192", (Object)"imq.cluster.brokerlist");
        }
        if (string2 != null) {
            this.logger.log(8, "B1192", (Object)"imq.cluster.brokerlist.manual");
        }
        LinkedHashSet<MQAddress> linkedHashSet = new LinkedHashSet<MQAddress>();
        Map map = this.allBrokers;
        synchronized (map) {
            for (Object v : this.allBrokers.values()) {
                HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)v;
                if (hAClusteredBroker.isLocalBroker()) continue;
                linkedHashSet.add(hAClusteredBroker.getBrokerURL());
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addBroker(MQAddress mQAddress, boolean bl, boolean bl2, UID uID) throws NoSuchElementException, BrokerException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        String string = null;
        ClusteredBroker clusteredBroker = null;
        if (bl) {
            string = this.localBrokerId;
            clusteredBroker = this.getBroker(string);
            if (clusteredBroker == null) {
                clusteredBroker = new HAClusteredBrokerImpl(string, mQAddress, this.VERSION, BrokerState.INITIALIZING, uID, this);
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
                clusteredBroker.setInstanceName(Globals.getConfigName());
            } else {
                ((HAClusteredBrokerImpl)clusteredBroker).setIsLocal(true);
                clusteredBroker.setInstanceName(Globals.getConfigName());
            }
            Map map = this.allBrokers;
            synchronized (map) {
                this.allBrokers.put(string, clusteredBroker);
            }
        } else {
            string = this.lookupBrokerID(mQAddress);
            if (string != null) {
                clusteredBroker = this.getBroker(string);
            }
        }
        if (uID != null) {
            ((HAClusteredBrokerImpl)clusteredBroker).setBrokerSessionUID(uID);
        }
        if (string == null) {
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B3169", string));
        }
        if (bl) {
            clusteredBroker.setStatus(257, null);
        } else {
            this.updateBroker(clusteredBroker);
        }
        this.brokerChanged(ClusterReason.ADDED, clusteredBroker.getBrokerName(), null, clusteredBroker, clusteredBroker.getBrokerSessionUID(), null);
        return string;
    }

    protected ClusteredBroker updateBrokerOnActivation(ClusteredBroker clusteredBroker, Object object) {
        return this.updateBroker(clusteredBroker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusteredBroker updateBroker(ClusteredBroker clusteredBroker) {
        Map map = this.allBrokers;
        synchronized (map) {
            return (HAClusteredBroker)((HAMap)this.allBrokers).get(clusteredBroker.getBrokerName(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateBroker(String string, Object object) throws NoSuchElementException {
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        ClusteredBroker clusteredBroker = this.getBroker(string);
        if (clusteredBroker == null) {
            throw new NoSuchElementException("Unknown brokerid " + string);
        }
        clusteredBroker.setInstanceName(null);
        HAClusterManagerImpl hAClusterManagerImpl = this;
        synchronized (hAClusterManagerImpl) {
            clusteredBroker.setStatus(BrokerStatus.setBrokerLinkIsDown(clusteredBroker.getStatus()), object);
        }
    }

    public String lookupStoreSessionOwner(UID uID) {
        try {
            return Globals.getStore().getStoreSessionOwner(uID.longValue());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3044", (Throwable)exception);
            return null;
        }
    }

    public String getStoreSessionCreator(UID uID) {
        try {
            return Globals.getStore().getStoreSessionCreator(uID.longValue());
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3044", (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupBrokerID(MQAddress mQAddress) {
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((HAMap)this.allBrokers).updateHAMap();
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(8, "B3044", (Throwable)brokerException);
        }
        return super.lookupBrokerID(mQAddress);
    }

    public int getConfigBrokerCount() {
        return super.getKnownBrokerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getKnownBrokers(boolean bl) {
        Map map;
        if (!this.initialized) {
            throw new RuntimeException("Cluster not initialized");
        }
        HashSet hashSet = null;
        if (bl) {
            try {
                map = this.allBrokers;
                synchronized (map) {
                    ((HAMap)this.allBrokers).updateHAMap(true);
                }
            }
            catch (BrokerException brokerException) {
                this.logger.logStack(16, "B3044", (Throwable)brokerException);
            }
        }
        map = this.allBrokers;
        synchronized (map) {
            hashSet = new HashSet(this.allBrokers.values());
        }
        return hashSet.iterator();
    }

    public Iterator getConfigBrokers() {
        return this.getKnownBrokers(true);
    }

    protected void addSupportedStoreSessionUID(UID uID) {
        super.addSupportedStoreSessionUID(uID);
    }

    protected void masterBrokerChanged(String string) {
        throw new UnsupportedOperationException("Can not use/set/ change masterbroker");
    }

    public void validate(String string, String string2) throws PropertyUpdateException {
        if (string.equals("imq.cluster.masterbroker")) {
            throw new PropertyUpdateException(Globals.getBrokerResources().getKString("B4250"));
        }
        super.validate(string, string2);
    }

    public ClusteredBroker getLocalBroker() {
        return super.getLocalBroker();
    }

    protected String getLocalBrokerName() {
        return this.localBroker;
    }

    public UID getStoreSessionUID() {
        if (this.localSessionUID == null) {
            this.localSessionUID = ((HAClusteredBroker)this.getLocalBroker()).getStoreSessionUID();
        }
        return this.localSessionUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredBroker getBroker(String string) {
        ClusteredBroker clusteredBroker = super.getBroker(string);
        if (clusteredBroker != null) {
            return clusteredBroker;
        }
        try {
            Map map = this.allBrokers;
            synchronized (map) {
                ((HAMap)this.allBrokers).updateHAMap(true);
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "B3044", (Throwable)brokerException);
        }
        return super.getBroker(string);
    }

    protected void brokerChanged(ClusterReason clusterReason, String string, Object object, Object object2, UID uID, Object object3) {
        super.brokerChanged(clusterReason, string, object, object2, uID, object3);
    }

    public class HAMap
    extends HashMap
    implements Map {
        public HAMap() throws BrokerException {
            HashMap hashMap = Globals.getStore().getAllBrokerInfos();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                HABrokerInfo hABrokerInfo = (HABrokerInfo)entry.getValue();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl(hABrokerInfo.getId(), hABrokerInfo, HAClusterManagerImpl.this);
                this.put(string, hAClusteredBrokerImpl);
                HAClusterManagerImpl.this.brokerChanged(ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
            }
        }

        public void updateHAMap() throws BrokerException {
            this.updateHAMap(false);
        }

        public void updateHAMap(boolean bl) throws BrokerException {
            if (bl) {
                this.updateHAMapForState(null);
            } else {
                this.updateHAMapForState(BrokerState.OPERATING);
            }
        }

        private void updateHAMapForState(BrokerState brokerState) throws BrokerException {
            Object object;
            String string;
            HashMap hashMap = brokerState == null ? Globals.getStore().getAllBrokerInfos() : Globals.getStore().getAllBrokerInfoByState(brokerState);
            for (Map.Entry entry : hashMap.entrySet()) {
                string = (String)entry.getKey();
                object = (HABrokerInfo)entry.getValue();
                HAClusteredBrokerImpl hAClusteredBrokerImpl = (HAClusteredBrokerImpl)this.get(string);
                if (hAClusteredBrokerImpl == null) {
                    HAClusteredBrokerImpl hAClusteredBrokerImpl2 = new HAClusteredBrokerImpl(((HABrokerInfo)object).getId(), (HABrokerInfo)object, HAClusterManagerImpl.this);
                    this.put(string, hAClusteredBrokerImpl2);
                    HAClusterManagerImpl.this.brokerChanged(ClusterReason.ADDED, hAClusteredBrokerImpl2.getBrokerName(), null, hAClusteredBrokerImpl2, hAClusteredBrokerImpl2.getBrokerSessionUID(), null);
                    continue;
                }
                hAClusteredBrokerImpl.update((HABrokerInfo)object);
            }
            if (brokerState == null) {
                Iterator iterator = this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    entry = iterator.next();
                    string = (String)entry.getKey();
                    if (hashMap.containsKey(string)) continue;
                    iterator.remove();
                    object = (HAClusteredBrokerImpl)entry.getValue();
                    HAClusterManagerImpl.this.brokerChanged(ClusterReason.REMOVED, ((HAClusteredBrokerImpl)object).getBrokerName(), object, null, ((HAClusteredBrokerImpl)object).getBrokerSessionUID(), null);
                }
            }
        }

        public Object get(Object object) {
            return this.get(object, false);
        }

        public Object get(Object object, boolean bl) {
            Object object2 = super.get(object);
            if (object2 == null || bl) {
                try {
                    HABrokerInfo hABrokerInfo = Globals.getStore().getBrokerInfo((String)object);
                    if (hABrokerInfo != null && object2 == null) {
                        HAClusteredBrokerImpl hAClusteredBrokerImpl = new HAClusteredBrokerImpl((String)object, hABrokerInfo, HAClusterManagerImpl.this);
                        this.put(object, hAClusteredBrokerImpl);
                        HAClusterManagerImpl.this.brokerChanged(ClusterReason.ADDED, hAClusteredBrokerImpl.getBrokerName(), null, hAClusteredBrokerImpl, hAClusteredBrokerImpl.getBrokerSessionUID(), null);
                        object2 = hAClusteredBrokerImpl;
                    }
                    if (hABrokerInfo != null && bl) {
                        ((HAClusteredBrokerImpl)object2).update(hABrokerInfo);
                    }
                }
                catch (BrokerException brokerException) {
                    HAClusterManagerImpl.this.logger.log(8, "B3100", (Object)(" exception while creating broker entry " + object), (Throwable)brokerException);
                }
            }
            return object2;
        }
    }
}

