/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterReason;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.service.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;

public class HAClusteredBrokerImpl
implements HAClusteredBroker {
    protected Logger logger = Globals.getLogger();
    boolean local = false;
    Integer status = new Integer(0);
    BrokerState state = BrokerState.INITIALIZING;
    String brokerid = null;
    MQAddress address = null;
    transient String instanceName = null;
    Integer version = new Integer(0);
    UID session = null;
    long heartbeat = 0L;
    String takeoverBroker = null;
    UID brokerSessionUID;
    HAClusterManagerImpl parent = null;

    public HAClusteredBrokerImpl(String string, HABrokerInfo hABrokerInfo, HAClusterManagerImpl hAClusterManagerImpl) throws BrokerException {
        this.parent = hAClusterManagerImpl;
        this.brokerid = string;
        this.status = new Integer(0);
        String string2 = hABrokerInfo.getUrl();
        try {
            this.address = BrokerMQAddress.createAddress(string2);
        }
        catch (Exception exception) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "invalid URL stored on disk " + string2, exception));
        }
        this.version = new Integer(hABrokerInfo.getVersion());
        this.state = BrokerState.getState(hABrokerInfo.getState());
        this.session = new UID(hABrokerInfo.getSessionID());
        this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
        this.heartbeat = hABrokerInfo.getHeartbeat();
    }

    public HAClusteredBrokerImpl(String string, MQAddress mQAddress, int n, BrokerState brokerState, UID uID, HAClusterManagerImpl hAClusterManagerImpl) throws BrokerException {
        this.parent = hAClusterManagerImpl;
        this.brokerid = string;
        this.local = this.local;
        this.status = new Integer(0);
        this.address = mQAddress;
        this.version = new Integer(n);
        this.state = brokerState;
        this.session = uID;
        this.takeoverBroker = "";
        this.brokerSessionUID = new UID();
        Store store = Globals.getStore();
        store.addBrokerInfo(string, this.address.toString(), brokerState, this.version, uID.longValue(), this.heartbeat);
        this.heartbeat = store.getBrokerHeartbeat(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClusteredBroker)) {
            return false;
        }
        return this.getBrokerName().equals(((ClusteredBroker)object).getBrokerName());
    }

    public int hashCode() {
        return this.getBrokerName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(HABrokerInfo hABrokerInfo) {
        MQAddress mQAddress = this.address;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            this.brokerid = hABrokerInfo.getId();
            String string = hABrokerInfo.getUrl();
            try {
                this.address = BrokerMQAddress.createAddress(string);
            }
            catch (Exception exception) {
                this.logger.logStack(16, exception.getMessage(), (Throwable)exception);
                this.address = mQAddress;
            }
            this.version = new Integer(hABrokerInfo.getVersion());
            this.state = BrokerState.getState(hABrokerInfo.getState());
            this.session = new UID(hABrokerInfo.getSessionID());
            this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
            this.heartbeat = hABrokerInfo.getHeartbeat();
        }
        if (!mQAddress.equals((Object)this.address)) {
            this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress, this.address, null, null);
        }
    }

    void setIsLocal(boolean bl) {
        this.local = bl;
    }

    public String toString() {
        if (!this.local) {
            return "-" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]" + ":" + BrokerStatus.toString(this.status);
        }
        return "*" + this.brokerid + "@" + this.address + ":" + this.state + "[StoreSession:" + this.session + ", BrokerSession:" + this.brokerSessionUID + "]" + ":" + BrokerStatus.toString(this.status);
    }

    public String getBrokerName() {
        return this.brokerid;
    }

    public MQAddress getBrokerURL() {
        return this.address;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public void setBrokerURL(MQAddress mQAddress) throws Exception {
        if (!this.local) {
            throw new UnsupportedOperationException("Only the local broker can have its url changed");
        }
        MQAddress mQAddress2 = this.address;
        try {
            this.updateEntry(1, null, mQAddress.toString());
            this.address = mQAddress;
        }
        catch (Exception exception) {
            this.logger.logStack(32, exception.getMessage() + "[" + mQAddress2 + ", " + mQAddress + "]" + this.brokerid, (Throwable)exception);
            throw exception;
        }
        this.parent.brokerChanged(ClusterReason.ADDRESS_CHANGED, this.getBrokerName(), mQAddress2, this.address, null, null);
    }

    public void resetTakeoverBrokerReadyOperating() throws Exception {
        if (!this.local) {
            throw new UnsupportedOperationException("Only the local broker can have its takeover broker reset");
        }
        this.getState();
        if (this.state == BrokerState.FAILOVER_PENDING || this.state == BrokerState.FAILOVER_STARTED) {
            String string = this.getTakeoverBroker();
            throw new IllegalStateException(Globals.getBrokerResources().getKString("B4310", string == null ? "" : string, this.toString()));
        }
        try {
            UID uID = this.updateEntry(2, this.state, this.getBrokerSessionUID());
            if (uID != null) {
                this.session = uID;
                this.parent.localSessionUID = uID;
            }
        }
        catch (Exception exception) {
            this.logger.logStack(32, exception.getMessage() + "[" + this.brokerid + "]", (Throwable)exception);
            throw exception;
        }
    }

    public boolean isLocalBroker() {
        return this.local;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized int getVersion() {
        return this.version == null ? 0 : this.version;
    }

    public synchronized void setVersion(int n) throws Exception {
        Integer n2 = this.version;
        Integer n3 = new Integer(n);
        if (this.local) {
            try {
                this.updateEntry(0, this.version, n3);
                this.version = n3;
            }
            catch (Exception exception) {
                this.logger.logStack(16, exception.getMessage() + "[" + n2 + ", " + n + "]" + this.brokerid, (Throwable)exception);
                throw exception;
            }
        }
        this.parent.brokerChanged(ClusterReason.VERSION_CHANGED, this.getBrokerName(), n2, this.version, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int n, Object object) {
        UID uID = null;
        Integer n2 = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (this.status == n) {
                return;
            }
            uID = this.getBrokerSessionUID();
            n2 = this.status;
            this.status = new Integer(n);
        }
        if (!n2.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n2, this.status, uID, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerIsUp(boolean bl, UID uID, Object object) {
        UID uID2 = uID;
        Integer n = null;
        Integer n2 = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (!bl && !uID2.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1337", "[BrokerSession:" + uID2 + "]", this.toString()));
                n = new Integer(16);
                n2 = BrokerStatus.setBrokerIsDown(n);
            } else {
                n = this.status;
                int n3 = 0;
                if (bl) {
                    n3 = BrokerStatus.setBrokerIsUp(this.status);
                } else {
                    n3 = BrokerStatus.setBrokerIsDown(this.status);
                    n3 = BrokerStatus.setBrokerNotInDoubt(n3);
                }
                uID2 = this.getBrokerSessionUID();
                n2 = this.status = new Integer(n3);
            }
        }
        if (!n.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID2, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerLinkUp(boolean bl, Object object) {
        UID uID = null;
        Integer n = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            n = this.status;
            int n2 = 0;
            uID = this.getBrokerSessionUID();
            n2 = bl ? BrokerStatus.setBrokerLinkIsUp(this.status) : BrokerStatus.setBrokerLinkIsDown(this.status);
            this.status = new Integer(n2);
        }
        if (!n.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, this.status, uID, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBrokerInDoubt(boolean bl, Object object) {
        UID uID = (UID)object;
        Integer n = null;
        Integer n2 = null;
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            if (bl && !uID.equals((Object)this.getBrokerSessionUID())) {
                this.logger.log(8, Globals.getBrokerResources().getKString("B1336", "[BrokerSession:" + uID + "]", this.toString()));
                n = new Integer(257);
                n2 = BrokerStatus.setBrokerInDoubt(n);
            } else {
                n = this.status;
                int n3 = 0;
                n3 = bl ? BrokerStatus.setBrokerInDoubt(this.status) : BrokerStatus.setBrokerNotInDoubt(this.status);
                uID = this.getBrokerSessionUID();
                n2 = this.status = new Integer(n3);
            }
        }
        if (!n.equals(this.status)) {
            this.parent.brokerChanged(ClusterReason.STATUS_CHANGED, this.getBrokerName(), n, n2, uID, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
        synchronized (hAClusteredBrokerImpl) {
            this.status = new Integer(BrokerStatus.setBrokerIsDown(this.status));
        }
    }

    public synchronized UID getStoreSessionUID() {
        return this.session;
    }

    public synchronized UID getBrokerSessionUID() {
        return this.brokerSessionUID;
    }

    public synchronized void setBrokerSessionUID(UID uID) {
        this.brokerSessionUID = uID;
    }

    public boolean isBrokerIDGenerated() {
        return false;
    }

    public synchronized String getTakeoverBroker() throws BrokerException {
        HABrokerInfo hABrokerInfo = Globals.getStore().getBrokerInfo(this.brokerid);
        if (hABrokerInfo == null) {
            this.logger.log(32, "B3169", (Object)this.brokerid);
            return null;
        }
        this.takeoverBroker = hABrokerInfo.getTakeoverBrokerID();
        return this.takeoverBroker;
    }

    public long getHeartbeat() throws BrokerException {
        this.heartbeat = Globals.getStore().getBrokerHeartbeat(this.brokerid);
        return this.heartbeat;
    }

    public synchronized long updateHeartbeat() throws BrokerException {
        return this.updateHeartbeat(false);
    }

    public synchronized long updateHeartbeat(boolean bl) throws BrokerException {
        Store store = Globals.getStore();
        Long l = null;
        if (bl) {
            l = store.updateBrokerHeartbeat(this.brokerid);
            if (l == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
            }
        } else {
            l = store.updateBrokerHeartbeat(this.brokerid, this.heartbeat);
            if (l == null) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B4223", this.brokerid, "Reset heartbeat timestamp due to synchronization problem."));
                l = store.updateBrokerHeartbeat(this.brokerid);
                if (l == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4223", this.brokerid, "Failed to reset heartbeat timestamp."));
                }
            }
        }
        this.heartbeat = l;
        return this.heartbeat;
    }

    private synchronized UID updateEntry(int n, Object object, Object object2) throws Exception {
        if (!this.local) {
            throw new IllegalAccessException("Can not update entry  for broker " + this.brokerid);
        }
        Store store = Globals.getStore();
        UID uID = store.updateBrokerInfo(this.brokerid, n, object, object2);
        try {
            this.heartbeat = store.getBrokerHeartbeat(this.brokerid);
        }
        catch (Exception exception) {
            this.logger.logStack(16, exception.getMessage() + "[" + this.brokerid + "]", (Throwable)exception);
        }
        return uID;
    }

    public BrokerState getState() throws BrokerException {
        BrokerState brokerState = this.state;
        this.state = Globals.getStore().getBrokerState(this.brokerid);
        if (brokerState != this.state && this.state != BrokerState.FAILOVER_PENDING) {
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState, this.state, null, null);
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateFailoverProcessed(UID uID) throws Exception {
        if (this.local) {
            throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_PROCESSED);
        }
        BrokerState brokerState = BrokerState.FAILOVER_PROCESSED;
        try {
            BrokerState brokerState2 = this.getState();
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (uID.equals((Object)this.session)) {
                    this.state = brokerState;
                } else {
                    brokerState2 = BrokerState.FAILOVER_COMPLETE;
                }
            }
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, brokerState, uID, null);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to update state " + BrokerState.FAILOVER_COMPLETE + " for " + this.brokerid);
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateFailoverFailed(UID uID) throws Exception {
        if (this.local) {
            throw new IllegalAccessException("Cannot update self state to " + BrokerState.FAILOVER_FAILED);
        }
        BrokerState brokerState = BrokerState.FAILOVER_FAILED;
        try {
            BrokerState brokerState2 = this.getState();
            HAClusteredBrokerImpl hAClusteredBrokerImpl = this;
            synchronized (hAClusteredBrokerImpl) {
                if (this.brokerSessionUID.equals((Object)uID)) {
                    this.state = brokerState;
                } else {
                    brokerState2 = BrokerState.OPERATING;
                }
            }
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, brokerState, uID, null);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to update state to " + BrokerState.FAILOVER_FAILED + " for " + this.brokerid);
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public void setState(BrokerState brokerState) throws IllegalAccessException, IllegalStateException, IndexOutOfBoundsException {
        if (!this.local && brokerState != BrokerState.FAILOVER_PROCESSED && brokerState != BrokerState.FAILOVER_STARTED && brokerState != BrokerState.FAILOVER_COMPLETE && brokerState != BrokerState.FAILOVER_FAILED) {
            throw new IllegalAccessException("Cannot update state  for broker " + this.brokerid);
        }
        try {
            BrokerState brokerState2 = this.getState();
            if (brokerState != BrokerState.FAILOVER_PENDING && brokerState != BrokerState.FAILOVER_PROCESSED && brokerState != BrokerState.FAILOVER_FAILED && !Globals.getStore().updateBrokerState(this.brokerid, brokerState, this.state, this.local)) {
                throw new IllegalStateException("Could not update broker state from " + brokerState2 + " to state " + brokerState + " for " + this.brokerid);
            }
            this.state = brokerState;
            this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.getBrokerName(), brokerState2, this.state, null, null);
        }
        catch (BrokerException brokerException) {
            IllegalStateException illegalStateException = new IllegalStateException(Globals.getBrokerResources().getKString("B3100", "Failed to update state for " + this.brokerid));
            illegalStateException.initCause(brokerException);
            throw illegalStateException;
        }
    }

    public TakeoverStoreInfo takeover(boolean bl, Object object, TakingoverTracker takingoverTracker) throws BrokerException {
        int n = Globals.getConfig().getIntProperty("imq.cluster.takeover.delay.interval", 0);
        if (n > 0) {
            try {
                Thread.sleep((long)n * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean bl2 = false;
        boolean bl3 = false;
        BrokerState brokerState = this.getState();
        if (!bl) {
            if (brokerState == BrokerState.INITIALIZING || brokerState == BrokerState.SHUTDOWN_STARTED || brokerState == BrokerState.SHUTDOWN_COMPLETE) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 405);
            }
            if (brokerState == BrokerState.FAILOVER_PENDING || brokerState == BrokerState.FAILOVER_STARTED || brokerState == BrokerState.FAILOVER_COMPLETE || brokerState == BrokerState.FAILOVER_PROCESSED) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B1191", this.brokerid), 409);
            }
        }
        long l = System.currentTimeMillis();
        BrokerState brokerState2 = BrokerState.FAILOVER_PENDING;
        Globals.getStore().getTakeOverLock(this.parent.getLocalBrokerName(), this.brokerid, takingoverTracker.getLastHeartbeat(), brokerState, l, brokerState2, bl, takingoverTracker);
        bl2 = true;
        this.state = brokerState2;
        this.logger.log(4, "state = FAILOVER_PENDING " + this.brokerid);
        this.parent.brokerChanged(ClusterReason.STATE_CHANGED, this.brokerid, brokerState, brokerState2, null, null);
        TakeoverStoreInfo takeoverStoreInfo = null;
        try {
            this.logger.log(4, "state = FAILOVER_STARTED " + this.brokerid);
            this.setState(BrokerState.FAILOVER_STARTED);
            takeoverStoreInfo = Globals.getStore().takeOverBrokerStore(this.parent.getLocalBrokerName(), this.brokerid, takingoverTracker);
            this.logger.log(4, "state = FAILOVER_COMPLETE " + this.brokerid);
            bl3 = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Internal error, shouldnt happen", illegalAccessException);
        }
        finally {
            if (bl2 && !bl3) {
                try {
                    this.setStateFailoverFailed(takingoverTracker.getBrokerSessionUID());
                }
                catch (Exception exception) {
                    this.logger.log(8, "Unable to set state to failed for broker " + this + ": " + exception.getMessage(), (Throwable)exception);
                }
                this.logger.log(16, "Failed to takeover :" + this.brokerid + " state expected is " + brokerState);
            }
        }
        this.heartbeat = l;
        this.parent.addSupportedStoreSessionUID(this.session);
        this.takeoverBroker = this.parent.getLocalBrokerName();
        return takeoverStoreInfo;
    }

    public boolean isConfigBroker() {
        return true;
    }
}

