/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;

public class ClusterTakeoverInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String brokerID = null;
    private UID storeSession = null;
    private UID brokerSession = null;
    private String brokerHost = null;
    private Long xid = null;
    private boolean fromTaker = true;
    private String taker = null;
    private Long timestamp = null;
    private boolean timedout = false;

    private ClusterTakeoverInfo(String string, UID uID, String string2, UID uID2, Long l, boolean bl, boolean bl2) {
        this.brokerID = string;
        this.storeSession = uID;
        this.brokerHost = string2;
        this.brokerSession = uID2;
        this.xid = l;
        this.fromTaker = bl;
        this.timedout = bl2;
    }

    private ClusterTakeoverInfo(GPacket gPacket) {
        assert (gPacket.getType() == 41 || gPacket.getType() == 39 || gPacket.getType() == 43);
        this.pkt = gPacket;
        this.brokerID = (String)gPacket.getProp((Object)"brokerID");
        this.storeSession = new UID(((Long)gPacket.getProp((Object)"storeSession")).longValue());
        Long l = (Long)gPacket.getProp((Object)"brokerSession");
        if (l != null) {
            this.brokerSession = new UID(l.longValue());
        }
        this.brokerHost = (String)gPacket.getProp((Object)"brokerHost");
        this.taker = (String)gPacket.getProp((Object)"taker");
        this.fromTaker = this.taker != null;
        this.timestamp = (Long)gPacket.getProp((Object)"timestamp");
        if (this.timestamp != null) {
            this.timedout = this.timestamp.equals(new Long(0L));
        }
        this.xid = (Long)gPacket.getProp((Object)"X");
    }

    public static ClusterTakeoverInfo newInstance(String string, UID uID) {
        return new ClusterTakeoverInfo(string, uID, null, null, null, false, false);
    }

    public static ClusterTakeoverInfo newInstance(String string, UID uID, String string2, UID uID2, Long l, boolean bl) {
        return new ClusterTakeoverInfo(string, uID, string2, uID2, l, bl, false);
    }

    public static ClusterTakeoverInfo newInstance(String string, UID uID, String string2, UID uID2, Long l, boolean bl, boolean bl2) {
        return new ClusterTakeoverInfo(string, uID, string2, uID2, l, bl, bl2);
    }

    public static ClusterTakeoverInfo newInstance(GPacket gPacket) {
        return new ClusterTakeoverInfo(gPacket);
    }

    public GPacket getGPacket(short s) throws BrokerException {
        assert (s == 41 || s == 39 || s == 43);
        if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Broker is not running in HA mode"));
        }
        if (this.pkt != null) {
            assert (this.pkt.getType() == s);
            return this.pkt;
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.putProp((Object)"brokerID", (Object)this.brokerID);
        gPacket.putProp((Object)"storeSession", (Object)new Long(this.storeSession.longValue()));
        if (s == 41) {
            gPacket.setType(s);
            gPacket.setBit(1, false);
            return gPacket;
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)Globals.getClusterManager().getLocalBroker();
        if (s == 39) {
            gPacket.setType((short)39);
            gPacket.setBit(1, false);
            gPacket.putProp((Object)"brokerSession", (Object)new Long(this.brokerSession.longValue()));
            gPacket.putProp((Object)"brokerHost", (Object)this.brokerHost);
            if (this.fromTaker) {
                this.taker = hAClusteredBroker.getBrokerName();
                gPacket.putProp((Object)"taker", (Object)this.taker);
                gPacket.putProp((Object)"timestamp", (Object)new Long(hAClusteredBroker.getHeartbeat()));
                gPacket.setBit(1, true);
            } else if (this.timedout) {
                gPacket.putProp((Object)"timestamp", (Object)new Long(0L));
            }
            gPacket.putProp((Object)"X", (Object)this.xid);
            return gPacket;
        }
        if (s == 43) {
            gPacket.setType((short)43);
            if (this.fromTaker) {
                gPacket.putProp((Object)"taker", (Object)hAClusteredBroker.getBrokerName());
            }
            gPacket.setBit(1, false);
            gPacket.putProp((Object)"X", (Object)this.xid);
            return gPacket;
        }
        throw new BrokerException("Unknown protocol: " + s);
    }

    public String getBrokerID() {
        return this.brokerID;
    }

    public UID getStoreSession() {
        return this.storeSession;
    }

    public Long getXid() {
        return this.xid;
    }

    public UID getBrokerSession() {
        return this.brokerSession;
    }

    public String getBrokerHost() {
        return this.brokerHost;
    }

    public String getTaker() {
        return this.taker;
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return this.timestamp;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public boolean isFromTaker() {
        return this.fromTaker;
    }

    public String toString() {
        if (this.pkt == null) {
            return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
        }
        if (this.pkt.getType() == 41) {
            return "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]";
        }
        if (this.pkt.getType() == 39) {
            String string = "";
            if (DEBUG) {
                if (this.getTaker() != null) {
                    string = this.getTaker() + "(" + (this.timestamp == null ? "" : "" + this.timestamp) + ":";
                }
                return string + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.getBrokerHost() + ", " + this.xid;
            }
            return string + "[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
        }
        return this.getTaker() + ":[brokerID=" + this.getBrokerID() + ", storeSession=" + this.getStoreSession() + "]" + (this.getBrokerSession() == null ? "" : "brokerSession=" + this.getBrokerSession()) + ", " + this.xid;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(short s, int n, String string) {
        assert (this.pkt != null);
        assert (s == 40);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gPacket.putProp((Object)"brokerID", this.pkt.getProp((Object)"brokerID"));
        gPacket.putProp((Object)"storeSession", this.pkt.getProp((Object)"storeSession"));
        gPacket.putProp((Object)"taker", this.pkt.getProp((Object)"taker"));
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        return gPacket;
    }

    public static int getReplyStatus(GPacket gPacket) {
        return (Integer)gPacket.getProp((Object)"S");
    }

    public static String getReplyStatusReason(GPacket gPacket) {
        return (String)gPacket.getProp((Object)"reason");
    }

    public static Long getReplyXid(GPacket gPacket) {
        return (Long)gPacket.getProp((Object)"X");
    }

    public static String toString(GPacket gPacket) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\treplyStatus = ").append(Status.getString((int)ClusterTakeoverInfo.getReplyStatus(gPacket)));
        if (gPacket.getProp((Object)"reason") != null) {
            stringBuffer.append("\n\treason = ").append(ClusterTakeoverInfo.getReplyStatusReason(gPacket));
        }
        stringBuffer.append("[brokerID = ").append((String)gPacket.getProp((Object)"brokerID"));
        stringBuffer.append(", storeSession = ").append((Long)gPacket.getProp((Object)"storeSession"));
        stringBuffer.append("], ").append((Long)gPacket.getProp((Object)"X"));
        stringBuffer.append(" - ").append((String)gPacket.getProp((Object)"taker"));
        return stringBuffer.toString();
    }
}

