/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterTakeoverMEInfo
implements ClusterProtocolHelper {
    protected Logger logger = Globals.getLogger();
    private String groupName = null;
    private String nodeName = null;
    private String masterHostPort = null;
    private String targetNodeName = null;
    private String uuid = null;
    private Long xid = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterTakeoverMEInfo(String string, String string2, String string3, String string4, String string5, Long l, Cluster cluster) {
        this.groupName = string;
        this.nodeName = string2;
        this.masterHostPort = string3;
        this.targetNodeName = string4;
        this.uuid = string5;
        this.xid = l;
        this.c = cluster;
    }

    private ClusterTakeoverMEInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterTakeoverMEInfo newInstance(String string, String string2, String string3, String string4, String string5, Long l, Cluster cluster) {
        return new ClusterTakeoverMEInfo(string, string2, string3, string4, string5, l, cluster);
    }

    public static ClusterTakeoverMEInfo newInstance(String string, String string2, String string3, Long l, Cluster cluster) {
        return new ClusterTakeoverMEInfo(null, string, null, string2, string3, l, cluster);
    }

    public static ClusterTakeoverMEInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterTakeoverMEInfo(gPacket, cluster);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)59);
        if (this.groupName != null) {
            gPacket.putProp((Object)"groupName", (Object)this.groupName);
        }
        gPacket.putProp((Object)"nodeName", (Object)this.nodeName);
        if (this.masterHostPort != null) {
            gPacket.putProp((Object)"masterHostPort", (Object)this.masterHostPort);
        }
        gPacket.putProp((Object)"clusterid", (Object)Globals.getClusterID());
        gPacket.putProp((Object)"targetNodeName", (Object)this.targetNodeName);
        gPacket.putProp((Object)"X", (Object)this.xid);
        gPacket.putProp((Object)"uuid", (Object)this.uuid);
        gPacket.putProp((Object)"TS", (Object)new Long(System.currentTimeMillis()));
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
        gPacket.setBit(1, true);
        return gPacket;
    }

    public String getGroupName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"groupName");
    }

    public String getNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"nodeName");
    }

    public String getMasterHostPort() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"masterHostPort");
    }

    public String getClusterID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"clusterid");
    }

    public String getTargetNodeName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"targetNodeName");
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"uuid");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int n, String string) {
        assert (this.pkt != null);
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)60);
        gPacket.putProp((Object)"X", (Object)((Long)this.pkt.getProp((Object)"X")));
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        return gPacket;
    }

    public void sendReply(BrokerAddress brokerAddress, int n, String string, Object object) {
        if (!this.needReply()) {
            return;
        }
        GPacket gPacket = this.getReplyGPacket(n, string);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(60), brokerAddress.toString(), this.toString()};
            BrokerResources brokerResources = Globals.getBrokerResources();
            Globals.getBrokerResources();
            this.logger.logStack(32, brokerResources.getKString("B3192", objectArray), (Throwable)exception);
        }
    }

    public String toString() {
        if (this.pkt == null) {
            return "[" + this.groupName + "[" + this.nodeName + ", " + this.masterHostPort + "]target=" + this.targetNodeName + ", xid=" + this.xid + ", uuid=" + this.uuid + "]";
        }
        return "[" + this.getGroupName() + "[" + this.getNodeName() + ", " + this.getMasterHostPort() + "]target=" + this.getTargetNodeName() + ", xid=" + this.getXid() + ", uuid=" + this.getUUID() + ", time=" + this.getTimestamp() + "]";
    }

    public static Long getReplyPacketXid(GPacket gPacket) {
        return (Long)gPacket.getProp((Object)"X");
    }
}

