/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.nio.ByteBuffer;

public class ClusterTransferFileEndInfo {
    private static boolean DEBUG = false;
    private GPacket pkt = null;
    private String uuid = null;
    private String module = null;
    private String brokerID = null;
    private String filename = null;
    private byte[] digest = null;
    private boolean moreFiles = false;

    private ClusterTransferFileEndInfo(String string, String string2, String string3, String string4, byte[] byArray, boolean bl) {
        this.uuid = string;
        this.brokerID = string3;
        this.module = string2;
        this.filename = string4;
        this.digest = byArray;
        this.moreFiles = bl;
    }

    private ClusterTransferFileEndInfo(GPacket gPacket) {
        assert (gPacket.getType() == 67);
        this.pkt = gPacket;
    }

    public static ClusterTransferFileEndInfo newInstance(String string, String string2, String string3, String string4, byte[] byArray, boolean bl) {
        return new ClusterTransferFileEndInfo(string, string2, string3, string4, byArray, bl);
    }

    public static ClusterTransferFileEndInfo newInstance(GPacket gPacket) {
        return new ClusterTransferFileEndInfo(gPacket);
    }

    public GPacket getGPacket() throws BrokerException {
        if (this.pkt != null) {
            return this.pkt;
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.putProp((Object)"uuid", (Object)this.uuid);
        gPacket.putProp((Object)"module", (Object)this.module);
        gPacket.putProp((Object)"brokerID", (Object)this.brokerID);
        gPacket.putProp((Object)"filename", (Object)this.filename);
        gPacket.putProp((Object)"morefiles", (Object)this.moreFiles);
        gPacket.setType((short)67);
        gPacket.setPayload(ByteBuffer.wrap(this.digest));
        gPacket.setBit(1, true);
        return gPacket;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"uuid");
    }

    public String getModule() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"module");
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"brokerID");
    }

    public String getFileName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"filename");
    }

    public boolean hasMoreFiles() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp((Object)"morefiles");
    }

    public byte[] getDigest() {
        assert (this.pkt != null);
        byte[] byArray = null;
        if (this.pkt.getPayload() != null) {
            byArray = this.pkt.getPayload().array();
        }
        return byArray;
    }

    public static GPacket getReplyGPacket(int n, String string) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)68);
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        return gPacket;
    }

    public static GPacket getReplyAckGPacket(int n, String string) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)69);
        gPacket.putProp((Object)"S", (Object)new Integer(n));
        if (string != null) {
            gPacket.putProp((Object)"reason", (Object)string);
        }
        return gPacket;
    }

    public static int getReplyStatus(GPacket gPacket) {
        return (Integer)gPacket.getProp((Object)"S");
    }

    public static String getReplyStatusReason(GPacket gPacket) {
        return (String)gPacket.getProp((Object)"reason");
    }

    public String toString() {
        if (this.pkt != null) {
            return "[brokerID=" + this.getBrokerID() + ", file=" + this.getFileName() + "]" + this.getUUID() + "(" + this.hasMoreFiles() + ")";
        }
        return "[brokerID=" + this.brokerID + ", file=" + this.filename + "]" + this.uuid + "(" + this.moreFiles + ")";
    }
}

