/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;

public class TakeoverCompleteHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TakeoverCompleteHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 41) {
            if (!Globals.getHAEnabled() && !Globals.isBDBStore()) {
                this.logger.log(32, "B3100", (Object)("Received Unexpected TAKEOVER_COMPLETE from " + brokerAddress));
                return;
            }
            this.handleTakeoverComplete(brokerAddress, gPacket);
        } else {
            this.logger.log(32, "B3100", (Object)("Cannot handle this packet :" + gPacket.toLongString()));
        }
    }

    public void handleTakeoverComplete(BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(gPacket);
        try {
            this.p.receivedTakeoverComplete(brokerAddress, clusterTakeoverInfo);
        }
        catch (Exception exception) {
            this.logger.logStack(8, "B3100", (Object)("Unable to process packet: " + gPacket), (Throwable)exception);
            return;
        }
    }
}

