/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileRequestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

public class TransferFileRequestHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TransferFileRequestHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "TransferFileRequestHandler");
        }
        if (gPacket.getType() == 61) {
            this.handleTransferFileRequest(brokerAddress, gPacket);
        } else if (gPacket.getType() == 62) {
            this.handleTransferFileRequestReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "TakeoverMEHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    private void handleTransferFileRequest(BrokerAddress brokerAddress, GPacket gPacket) {
        String string;
        int n;
        block4: {
            n = 200;
            string = null;
            try {
                this.p.receivedTransferFileRequest(brokerAddress, gPacket);
            }
            catch (Exception exception) {
                n = 500;
                string = exception.getMessage();
                if (exception instanceof BrokerException) break block4;
                Object[] objectArray = new String[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress.toString(), exception.toString()};
                string = this.br.getKString("B3269", objectArray);
                this.logger.log(32, string);
            }
        }
        ClusterTransferFileRequestInfo clusterTransferFileRequestInfo = ClusterTransferFileRequestInfo.newInstance(gPacket);
        try {
            this.c.unicast(brokerAddress, clusterTransferFileRequestInfo.getReplyGPacket(n, string));
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(62), brokerAddress, clusterTransferFileRequestInfo.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", (Object)objectArray), (Throwable)iOException);
        }
    }

    private void handleTransferFileRequestReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.p.receivedTransferFileRequestReply(brokerAddress, gPacket);
    }
}

