/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerStates;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerStatesTupleBinding;
import com.sun.messaging.jmq.jmsserver.persist.bdb.MessageEnumeration;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

class DstMsgStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    DestinationUID myduid = null;
    private BDBStore parent = null;
    private Database msgdb = null;
    private Database cssdb = null;
    private TupleBinding cssBinding = null;

    protected static String getDstMsgDatabaseName(DestinationUID destinationUID) {
        StringBuffer stringBuffer = new StringBuffer(destinationUID.toString());
        int n = -1;
        while ((n = stringBuffer.indexOf(":")) != -1) {
            stringBuffer.deleteCharAt(n);
        }
        return stringBuffer.toString();
    }

    protected DestinationUID getMyDestinationUID() {
        return this.myduid;
    }

    protected DstMsgStore(Transaction transaction, DestinationUID destinationUID, boolean bl, BDBStore bDBStore) throws BrokerException, DatabaseNotFoundException {
        this.parent = bDBStore;
        this.myduid = destinationUID;
        DstMsgStore.getDstMsgDatabaseName(destinationUID);
        boolean bl2 = false;
        try {
            DatabaseConfig databaseConfig = new DatabaseConfig();
            databaseConfig.setReadOnly(this.parent.getDBEnv().getConfig().getReadOnly());
            databaseConfig.setAllowCreate(bl);
            databaseConfig.setTransactional(true);
            databaseConfig.setSortedDuplicates(false);
            Environment environment = this.parent.getDBEnv();
            try {
                this.msgdb = environment.openDatabase(transaction, DstMsgStore.getDstMsgDatabaseName(destinationUID), databaseConfig);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                if (!bl) {
                    bl2 = true;
                }
                throw databaseNotFoundException;
            }
            this.cssdb = environment.openDatabase(transaction, DstMsgStore.getDstMsgDatabaseName(destinationUID) + "_cs", databaseConfig);
            this.cssBinding = new ConsumerStatesTupleBinding();
        }
        catch (Exception exception) {
            if (exception instanceof DatabaseNotFoundException && bl2) {
                throw (DatabaseNotFoundException)((Object)exception);
            }
            String string = "XXXFailed to open message database for destination " + destinationUID;
            this.logger.logStack(32, string, (Throwable)exception);
            throw new BrokerException(string, exception);
        }
    }

    protected void storeMessage(Transaction transaction, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        SysMessageID sysMessageID = packet.getSysMessageID();
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry(packet.getBytes());
            OperationStatus operationStatus = this.msgdb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3008", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            if (consumerUIDArray == null || consumerUIDArray.length == 0) {
                return;
            }
            databaseEntry2 = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)new ConsumerStates(consumerUIDArray, nArray), databaseEntry2);
            operationStatus = this.cssdb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3008", sysMessageID, "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4004", sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void removeMessage(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            OperationStatus operationStatus = this.msgdb.delete(transaction, databaseEntry);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(16, string);
                throw new BrokerException(string);
            }
            operationStatus = this.cssdb.delete(transaction, databaseEntry);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return;
            }
        }
        catch (Exception exception) {
            String string = this.br.getString("B4033", sysMessageID + "[" + this.myduid.getName() + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected static void removeDestination(Transaction transaction, DestinationUID destinationUID, DstMsgStore dstMsgStore, BDBStore bDBStore) throws BrokerException {
        String string = DstMsgStore.getDstMsgDatabaseName(destinationUID);
        String string2 = string + "_cs";
        boolean bl = false;
        try {
            Object object;
            if (dstMsgStore != null) {
                block12: {
                    object = null;
                    try {
                        dstMsgStore.msgdb.close();
                    }
                    catch (Exception exception) {
                        object = exception;
                    }
                    try {
                        dstMsgStore.cssdb.close();
                    }
                    catch (Exception exception) {
                        if (object == null) break block12;
                        object = exception;
                    }
                }
                if (object != null) {
                    throw object;
                }
            }
            object = bDBStore.getDBEnv();
            try {
                object.removeDatabase(transaction, string);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                if (dstMsgStore == null) {
                    bl = true;
                }
                throw databaseNotFoundException;
            }
            object.removeDatabase(transaction, string2);
        }
        catch (Exception exception) {
            if (exception instanceof DatabaseNotFoundException && bl) {
                return;
            }
            String string3 = dstMsgStore == null ? "" : dstMsgStore.msgdb.getDatabaseName();
            String string4 = "Failed to remove message database " + string3 + " for destination " + destinationUID;
            Globals.getLogger().logStack(32, string4, (Throwable)exception);
            throw new BrokerException(string4, exception);
        }
    }

    protected static Enumeration messageEnumeration(DstMsgStore dstMsgStore, BDBStore bDBStore) throws BrokerException {
        return new MessageEnumeration(dstMsgStore == null ? null : dstMsgStore.msgdb, bDBStore);
    }

    protected void close() {
        try {
            this.msgdb.close();
        }
        catch (Exception exception) {
            this.logger.log(16, "Exception in closing message database for destination " + this.myduid);
        }
        try {
            this.cssdb.close();
        }
        catch (Exception exception) {
            this.logger.log(16, "Exception in closing consumer state database for destination " + this.myduid);
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("myduid", this.myduid.toString());
        hashtable.put("msgdb", this.msgdb.getDatabaseName());
        hashtable.put("msgdbCount", String.valueOf(this.msgdb.count()));
        hashtable.put("msgdbConfig", this.msgdb.getConfig().toString());
        hashtable.put("cssdb", this.cssdb.getDatabaseName());
        hashtable.put("cssdbCount", String.valueOf(this.cssdb.count()));
        hashtable.put("cssdbConfig", this.cssdb.getConfig().toString());
        return hashtable;
    }

    protected void storeInterestStates(Transaction transaction, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus != OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3084", sysMessageID + "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            databaseEntry2 = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)new ConsumerStates(consumerUIDArray, nArray), databaseEntry2);
            operationStatus = this.cssdb.putNoOverwrite(transaction, databaseEntry, databaseEntry2);
            if (operationStatus == OperationStatus.KEYEXIST) {
                String string = this.br.getKString("B3084", sysMessageID + "[" + this.cssdb.getDatabaseName() + "]");
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4105", sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected void updateInterestState(Transaction transaction, SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            databaseEntry2 = new DatabaseEntry();
            operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, LockMode.RMW);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = "XXX Interest list for message " + sysMessageID + "[" + this.myduid + "] not found in store";
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            ConsumerStates consumerStates = (ConsumerStates)this.cssBinding.entryToObject(databaseEntry2);
            consumerStates.setSysMessageID(sysMessageID);
            consumerStates.updateConsumerState(consumerUID, n);
            consumerStates.toArrays();
            databaseEntry2 = new DatabaseEntry();
            this.cssBinding.objectToEntry((Object)consumerStates, databaseEntry2);
            this.cssdb.put(transaction, databaseEntry, databaseEntry2);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4015", consumerUID, sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected int getInterestState(Transaction transaction, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            databaseEntry2 = new DatabaseEntry();
            operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = "XXX Interest list for message " + sysMessageID + "[" + this.myduid + "] not found in store";
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            ConsumerStates consumerStates = (ConsumerStates)this.cssBinding.entryToObject(databaseEntry2);
            consumerStates.setSysMessageID(sysMessageID);
            return consumerStates.getConsumerState(consumerUID);
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4036", consumerUID, sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected HashMap getInterestStates(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            databaseEntry2 = new DatabaseEntry();
            operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = "XXX Interest list for message " + sysMessageID + "[" + this.myduid + "] not found in store";
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            ConsumerStates consumerStates = (ConsumerStates)this.cssBinding.entryToObject(databaseEntry2);
            consumerStates.setSysMessageID(sysMessageID);
            return consumerStates.getInterestStates();
        }
        catch (Exception exception) {
            String string = "Failed to get interest list for mesage" + sysMessageID + "[" + this.myduid + "]";
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            databaseEntry2 = new DatabaseEntry();
            operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = "XXX Interest list for message " + sysMessageID + "[" + this.myduid + "] not found in store";
                this.logger.log(32, string);
                throw new BrokerException(string);
            }
            ConsumerStates consumerStates = (ConsumerStates)this.cssBinding.entryToObject(databaseEntry2);
            return consumerStates.getUnAckedConsumerUIDs();
        }
        catch (Exception exception) {
            String string = "Failed to get interest list for mesage" + sysMessageID + "[" + this.myduid + "]";
            this.logger.log(32, string);
            throw new BrokerException(string, exception);
        }
    }

    protected Packet getMessage(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                String string = this.br.getKString("B3007", sysMessageID, this.myduid);
                this.logger.log(16, string);
                throw new BrokerException(string);
            }
            return DstMsgStore.parseMessage(databaseEntry2.getData());
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4107", sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
    }

    protected static HashMap getMessageStorageInfo(Transaction transaction, DstMsgStore dstMsgStore) throws BrokerException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        int n = 0;
        long l = 0L;
        if (dstMsgStore == null) {
            hashMap.put("numMsgs", n);
            hashMap.put("totalMsgBytes", l);
            return hashMap;
        }
        Cursor cursor = null;
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            databaseEntry.setPartial(0, 0, true);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            cursor = dstMsgStore.msgdb.openCursor(transaction, null);
            while (cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                ++n;
                l += (long)databaseEntry2.getData().length;
            }
            cursor.close();
            hashMap.put("numMsgs", n);
            hashMap.put("totalMsgBytes", l);
            HashMap<String, Number> hashMap2 = hashMap;
            return hashMap2;
        }
        catch (Exception exception) {
            String string = "XXX Failed to get message count from store for destiation " + dstMsgStore.myduid;
            Globals.getLogger().log(32, string);
            throw new BrokerException(string, exception);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception exception) {
                    Globals.getLogger().log(16, "Failed to close cursor in getting message count from store for destination " + dstMsgStore.myduid + ": " + exception.getMessage());
                }
            }
        }
    }

    protected boolean containsMessage(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            databaseEntry2.setPartial(0, 0, true);
            OperationStatus operationStatus = this.msgdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return false;
            }
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4107", sysMessageID + "[" + this.myduid + "]");
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
        return true;
    }

    protected boolean hasMessageBeenAcked(Transaction transaction, SysMessageID sysMessageID) throws BrokerException {
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry(sysMessageID.toString().getBytes("UTF-8"));
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.cssdb.get(transaction, databaseEntry, databaseEntry2, null);
            if (operationStatus == OperationStatus.NOTFOUND) {
                return false;
            }
            ConsumerStates consumerStates = (ConsumerStates)this.cssBinding.entryToObject(databaseEntry2);
            consumerStates.setSysMessageID(sysMessageID);
            return consumerStates.hasMessageBeenAcked();
        }
        catch (Exception exception) {
            String string = this.br.getKString("B4107", sysMessageID + "[" + this.cssdb.getDatabaseName() + "]");
            this.logger.log(32, string);
            throw new BrokerException(string);
        }
    }

    protected static Packet parseMessage(byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        JMQByteBufferInputStream jMQByteBufferInputStream = new JMQByteBufferInputStream(byteBuffer);
        Packet packet = new Packet(false);
        packet.generateTimestamp(false);
        packet.generateSequenceNumber(false);
        packet.readPacket((InputStream)jMQByteBufferInputStream);
        jMQByteBufferInputStream.close();
        return packet;
    }
}

