/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterProtocolHelper;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;

class JoinRunnable
implements Runnable {
    String groupName = null;
    String nodeName = null;
    String masterHostPort = null;
    Integer replicaPort = null;
    byte[] commitToken = null;
    Long syncTimeout = null;
    BrokerAddress from = null;
    BDBStore store = null;
    ClusterProtocolHelper cpi = null;
    boolean takeoverPrepare = false;
    String uuid = null;

    public JoinRunnable(String string, String string2, String string3, Integer n, byte[] byArray, Long l, boolean bl, String string4, BrokerAddress brokerAddress, ClusterProtocolHelper clusterProtocolHelper, BDBStore bDBStore) {
        this.groupName = string;
        this.nodeName = string2;
        this.masterHostPort = string3;
        this.replicaPort = n;
        this.commitToken = byArray;
        this.syncTimeout = l;
        this.takeoverPrepare = bl;
        this.uuid = string4;
        this.from = brokerAddress;
        this.store = bDBStore;
        this.cpi = clusterProtocolHelper;
    }

    public void run() {
        int n = 200;
        String string = null;
        try {
            ReplicatedEnvironment replicatedEnvironment = this.store.joinReplicationGroup(this.groupName, this.nodeName, this.masterHostPort, this.replicaPort, this.commitToken, this.syncTimeout, this.takeoverPrepare, false, this.from);
            if (this.takeoverPrepare) {
                this.store.storeTakeoverSession(this.nodeName, "TAKEOVER_PREPARED:" + this.uuid + ":" + replicatedEnvironment.getRepConfig().getNodeHostPort(), true, true, new String[]{"TAKEOVER_PREPARE:" + this.uuid});
            }
            this.cpi.sendReply(this.from, n, string, replicatedEnvironment.getRepConfig().getNodeHostPort());
        }
        catch (Throwable throwable) {
            n = 500;
            string = throwable.getMessage();
            Globals.getLogger().logStack(32, throwable.getMessage() + this.cpi, throwable);
            this.cpi.sendReply(this.from, n, string, null);
            return;
        }
    }
}

