/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.builder.instanceroot;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.uberjar.builder.instanceroot.InstanceRootBuilderUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class InstanceRootBuilder
implements BundleActivator {
    private static final Logger logger = Logger.getLogger("embedded-glassfish");
    private static String resourceroot = "glassfish8/glassfish/domains/domain1/";

    public void start(BundleContext context) throws Exception {
        String instanceRoot = context.getProperty("com.sun.aas.instanceRoot");
        this.buildInstanceRoot(context.getBundle(), instanceRoot);
    }

    public void stop(BundleContext context) throws Exception {
        logger.fine("InstanceRootBuilder stopped");
    }

    private void buildInstanceRoot(Bundle bundle, String instanceRoot) throws Exception {
        List<String> resources = this.getResources(bundle, resourceroot);
        for (String resource : resources) {
            InstanceRootBuilderUtil.copy(bundle.getResource(resource).openConnection().getInputStream(), instanceRoot, resource.substring(resourceroot.length()));
        }
    }

    private List<String> getResources(Bundle b, String ... subpaths) {
        ArrayList<String> resources = new ArrayList<String>();
        if (subpaths == null || subpaths.length == 0) {
            subpaths = new String[]{"/"};
        }
        for (String subpath : subpaths) {
            Enumeration e = b.getEntryPaths(subpath);
            while (e != null && e.hasMoreElements()) {
                String entryPath = (String)e.nextElement();
                if (entryPath.endsWith("/")) {
                    resources.addAll(this.getResources(b, entryPath));
                    continue;
                }
                resources.add(entryPath);
            }
        }
        return resources;
    }
}

