/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.osgimain;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.uberjar.osgimain.ModuleExtractor;
import org.glassfish.uberjar.osgimain.OSGIModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Main
implements BundleActivator {
    private static final String UBER_JAR_URI = "org.glassfish.embedded.osgimain.jarURI";
    public static final String AUTO_START_BUNDLES_PROP = "org.glassfish.embedded.osgimain.autostartBundles";
    private List<String> excludedModules = new ArrayList<String>();
    private List<Bundle> autoStartBundles = new ArrayList<Bundle>();
    HashMap<String, Bundle> autostartBundles = new HashMap();
    private static final Logger logger = Logger.getLogger("embedded-glassfish");

    public void start(final BundleContext context) throws Exception {
        logger.logp(Level.FINER, "Main", "start", "Start has been called. BundleContext = {0}", context);
        URI embeddedJarURI = new URI(context.getProperty(UBER_JAR_URI));
        final String autoStartBundleLocation = context.getProperty(AUTO_START_BUNDLES_PROP);
        logger.info("Please wait while the GlassFish is being initialized...");
        logger.finer("embeddedJar = " + embeddedJarURI + ", autoStartBundles = " + autoStartBundleLocation);
        logger.finer("Installing GlassFish bundles. Please wait.....");
        ExecutorService executor = Executors.newFixedThreadPool(10);
        Bundle[] bundles = context.getBundles();
        final HashMap<String, Bundle> installedBundles = new HashMap<String, Bundle>();
        if (bundles != null && bundles.length > 0) {
            for (Bundle b : bundles) {
                installedBundles.put(b.getSymbolicName(), b);
            }
        }
        final File embeddedJar = new File(embeddedJarURI);
        Iterator<OSGIModule> iterator = ModuleExtractor.extractModules(embeddedJar).iterator();
        while (iterator.hasNext()) {
            OSGIModule module;
            final OSGIModule m = module = iterator.next();
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        String bundleLocation = m.getLocation();
                        if (!Main.this.excludedModules.contains(bundleLocation)) {
                            Bundle installed;
                            Bundle bundle = installed = m.getBundleSymbolicName() != null ? (Bundle)installedBundles.get(m.getBundleSymbolicName()) : null;
                            if (installed == null) {
                                installed = context.installBundle(bundleLocation, m.getContentStream());
                            } else if (installed.getLastModified() < embeddedJar.lastModified()) {
                                installed.update(m.getContentStream());
                            }
                            if (autoStartBundleLocation.indexOf(bundleLocation) != -1) {
                                Main.this.autostartBundles.put(bundleLocation, installed);
                            }
                        }
                        m.close();
                    }
                    catch (Exception ex) {
                        logger.finer(ex.getMessage());
                    }
                }
            });
        }
        logger.finer("Waiting to complete installation of all bundles. Please wait.....");
        executor.shutdown();
        boolean completed = executor.awaitTermination(120L, TimeUnit.SECONDS);
        logger.finer("Completed successfully ? " + completed);
        if (autoStartBundleLocation != null) {
            String bundleLocation;
            StringTokenizer st = new StringTokenizer(autoStartBundleLocation, ",");
            while (st.hasMoreTokens() && !(bundleLocation = st.nextToken().trim()).isEmpty()) {
                Bundle b = this.autostartBundles.get(bundleLocation);
                if (b != null) {
                    logger.finer("Starting bundle " + b);
                    try {
                        b.start();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    logger.finer("Started bundle " + b);
                    continue;
                }
                logger.warning("Unable to find bundle with location " + bundleLocation);
            }
        }
        logger.finer("Autostart bundles = " + this.autoStartBundles);
        for (Bundle bundle : this.autoStartBundles) {
            bundle.start();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.logp(Level.FINER, "Main", "stop", "Stop has been called. BundleContext = {0}", bundleContext);
    }
}

