/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.uberjar.osgimain;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.uberjar.osgimain.OSGIModule;

public class ModuleExtractor {
    private static final Logger logger = Logger.getLogger("embedded-glassfish");
    private static String MODULES_DIR_PREFIX = "modules";
    private static String MODULES_DIR_SUFFIX = "_jar/";
    private static final char SLASH = '/';
    private static final String JARFILE_URL_PREFIX = "jar:file:";
    private static final String JARENTRY_PREFIX = "!/";
    private static final int BYTEBUFFER_SIZE = 10240;

    public static Iterable<OSGIModule> extractModules(File modulesJarFile) {
        Enumeration<JarEntry> entries;
        JarFile modulesJar;
        try {
            modulesJar = new JarFile(modulesJarFile);
            entries = modulesJar.entries();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
        return new Iterable<OSGIModule>(){

            @Override
            public Iterator<OSGIModule> iterator() {
                return new Iterator<OSGIModule>(){
                    JarEntry nextEntry = this.getNextEntry();

                    @Override
                    public boolean hasNext() {
                        return this.nextEntry != null;
                    }

                    @Override
                    public OSGIModule next() {
                        OSGIModule b = null;
                        try {
                            b = ModuleExtractor.getModule(this.nextEntry.getName(), modulesJar);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.nextEntry = this.getNextEntry();
                        return b;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal via iterator is not supported");
                    }

                    private JarEntry getNextEntry() {
                        JarEntry nextEntry = null;
                        while (entries.hasMoreElements()) {
                            JarEntry entry = (JarEntry)entries.nextElement();
                            if (!entry.isDirectory() || !entry.getName().startsWith(MODULES_DIR_PREFIX) || !entry.getName().endsWith(MODULES_DIR_SUFFIX)) continue;
                            nextEntry = entry;
                            break;
                        }
                        return nextEntry;
                    }
                };
            }
        };
    }

    public static OSGIModule getModule(final String modulePath, final JarFile modulesJar) throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        final OSGIModule b = new OSGIModule();
        b.setContentStream(pis);
        b.setLocation(JARFILE_URL_PREFIX + modulesJar.getName() + JARENTRY_PREFIX + modulePath);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Manifest m;
                    ZipEntry manifestEntry = modulesJar.getEntry(modulePath + "META-INF/MANIFEST.MF");
                    try (InputStream in = modulesJar.getInputStream(manifestEntry);){
                        Attributes attrs;
                        m = new Manifest(in);
                        if (m != null && (attrs = m.getMainAttributes()) != null) {
                            b.setBundleSymbolicName(attrs.getValue("Bundle-SymbolicName"));
                        }
                    }
                    JarOutputStream jos = new JarOutputStream((OutputStream)pos, m);
                    jos.setLevel(0);
                    ByteBuffer buf = ByteBuffer.allocate(10240);
                    Enumeration<JarEntry> entries = modulesJar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(modulePath) || entry.getName().indexOf("META-INF/MANIFEST.MF") != -1) continue;
                        String entryName = entry.getName();
                        entryName = entryName.substring(modulePath.length());
                        jos.putNextEntry(new JarEntry(entryName));
                        in = modulesJar.getInputStream(entry);
                        try {
                            ModuleExtractor.copy(in, jos, buf);
                        }
                        finally {
                            in.close();
                        }
                        jos.closeEntry();
                    }
                    jos.close();
                    pos.close();
                }
                catch (IOException ex) {
                    b.getExceptionHandler().handle(ex);
                }
            }
        }.start();
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out, ByteBuffer byteBuffer) throws IOException {
        try {
            int read;
            ReadableByteChannel inChannel = Channels.newChannel(in);
            WritableByteChannel outChannel = Channels.newChannel(out);
            do {
                if ((read = inChannel.read(byteBuffer)) <= 0) continue;
                byteBuffer.limit(byteBuffer.position());
                byteBuffer.rewind();
                int written = 0;
                while ((written += outChannel.write(byteBuffer)) < read) {
                }
                if (logger.isLoggable(Level.FINER) && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINE, "JarHelper", "write", "Copied {0} bytes", new Object[]{read});
                }
                byteBuffer.clear();
            } while (read != -1);
        }
        finally {
            byteBuffer.clear();
        }
    }

    public static void main(String[] args) throws Exception {
        int bundleCount = 0;
        for (OSGIModule b : ModuleExtractor.extractModules(new File(args[0]))) {
            int count;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] array = new byte[10240];
            while ((count = b.getContentStream().read(array)) != -1) {
                out.write(array, 0, count);
            }
            ++bundleCount;
            logger.info("b.name = " + b.getLocation() + ", b.streamSize = " + out.size());
        }
        logger.info("Total number of bundles = " + bundleCount);
    }
}

