/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.VerifierException;
import com.sun.btrace.annotations.CalledInstance;
import com.sun.btrace.annotations.CalledMethod;
import com.sun.btrace.annotations.Kind;
import com.sun.btrace.annotations.Return;
import com.sun.btrace.annotations.Self;
import com.sun.btrace.annotations.Where;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.FieldVisitor;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.Location;
import com.sun.btrace.runtime.MethodVerifier;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.OnProbe;
import com.sun.btrace.util.Messages;
import com.sun.btrace.util.NullVisitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;

public class Verifier
extends ClassAdapter {
    public static final String BTRACE_SELF_DESC = Type.getDescriptor(Self.class);
    public static final String BTRACE_RETURN_DESC = Type.getDescriptor(Return.class);
    public static final String BTRACE_CALLEDMETHOD_DESC = Type.getDescriptor(CalledMethod.class);
    public static final String BTRACE_CALLEDINSTANCE_DESC = Type.getDescriptor(CalledInstance.class);
    private boolean seenBTrace;
    private String className;
    private List<OnMethod> onMethods;
    private List<OnProbe> onProbes;
    private boolean unsafe;

    public Verifier(ClassVisitor cv, boolean unsafe) {
        super(cv);
        this.unsafe = unsafe;
        this.onMethods = new ArrayList<OnMethod>();
        this.onProbes = new ArrayList<OnProbe>();
    }

    public Verifier(ClassVisitor cv) {
        this(cv, false);
    }

    public String getClassName() {
        return this.className;
    }

    public List<OnMethod> getOnMethods() {
        return this.onMethods;
    }

    public List<OnProbe> getOnProbes() {
        return this.onProbes;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) != 0 || (access & 0x4000) != 0) {
            this.reportError("btrace.program.should.be.class");
        }
        if ((access & 1) == 0) {
            this.reportError("class.should.be.public", name);
        }
        if (!superName.equals(Constants.JAVA_LANG_OBJECT)) {
            this.reportError("object.superclass.required", superName);
        }
        if (interfaces != null && interfaces.length > 0) {
            this.reportError("no.interface.implementation");
        }
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(Constants.BTRACE_DESC)) {
            this.seenBTrace = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.seenBTrace) {
            this.reportError("not.a.btrace.program");
        }
        if ((access & 8) == 0) {
            this.reportError("no.instance.variables", name);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.className.equals(outerName) || this.className.equals(innerName)) {
            this.reportError("no.nested.class");
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, final String methodName, final String methodDesc, String signature, String[] exceptions) {
        if (!this.seenBTrace) {
            this.reportError("not.a.btrace.program");
        }
        if ((access & 1) == 0 && !methodName.equals("<clinit>")) {
            this.reportError("method.should.be.public", methodName + methodDesc);
        }
        if ((access & 0x20) != 0) {
            this.reportError("no.synchronized.methods", methodName + methodDesc);
        }
        if (!methodName.equals("<init>") && (access & 8) == 0) {
            this.reportError("no.instance.method", methodName + methodDesc);
        }
        if (Type.getReturnType(methodDesc) != Type.VOID_TYPE) {
            this.reportError("return.type.should.be.void", methodName + methodDesc);
        }
        MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new MethodVerifier(this, mv, this.className){
            private OnMethod om;
            {
                super(x0, x1, x2);
                this.om = null;
            }

            @Override
            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                if (desc.equals(BTRACE_SELF_DESC) && this.om != null) {
                    if (this.om.getLocation().getValue() == Kind.ENTRY || this.om.getLocation().getValue() == Kind.RETURN || this.om.getLocation().getValue() == Kind.CALL) {
                        this.om.setSelfParameter(parameter);
                    } else {
                        Verifier.this.reportError("self.desc.invalid", methodName + methodDesc + "(" + parameter + ")");
                    }
                }
                if (desc.equals(BTRACE_RETURN_DESC) && this.om != null) {
                    if (this.om.getLocation().getValue() == Kind.RETURN || this.om.getLocation().getValue() == Kind.CALL && this.om.getLocation().getWhere() == Where.AFTER) {
                        this.om.setReturnParameter(parameter);
                    } else {
                        Verifier.this.reportError("return.desc.invalid", methodName + methodDesc + "(" + parameter + ")");
                    }
                }
                if (desc.equals(BTRACE_CALLEDMETHOD_DESC) && this.om != null) {
                    if (this.om.getLocation().getValue() == Kind.CALL) {
                        this.om.setCalledMethodParameter(parameter);
                    } else {
                        Verifier.this.reportError("called-method.desc.invalid", methodName + methodDesc + "(" + parameter + ")");
                    }
                }
                if (desc.equals(BTRACE_CALLEDINSTANCE_DESC) && this.om != null) {
                    if (this.om.getLocation().getValue() == Kind.CALL) {
                        this.om.setCalledInstanceParameter(parameter);
                    } else {
                        Verifier.this.reportError("called-instance.desc.invalid", methodName + methodDesc + "(" + parameter + ")");
                    }
                }
                return super.visitParameterAnnotation(parameter, desc, visible);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (desc.equals(Constants.ONMETHOD_DESC)) {
                    this.om = new OnMethod();
                    Verifier.this.onMethods.add(this.om);
                    this.om.setTargetName(methodName);
                    this.om.setTargetDescriptor(methodDesc);
                    return new NullVisitor(){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("clazz")) {
                                om.setClazz((String)value);
                            } else if (name.equals("method")) {
                                om.setMethod((String)value);
                            } else if (name.equals("type")) {
                                om.setType((String)value);
                            }
                        }

                        @Override
                        public AnnotationVisitor visitAnnotation(String name, String desc) {
                            if (desc.equals(Constants.LOCATION_DESC)) {
                                final Location loc = new Location();
                                return new NullVisitor(){

                                    @Override
                                    public void visitEnum(String name, String desc, String value) {
                                        if (desc.equals(Constants.WHERE_DESC)) {
                                            loc.setWhere(Enum.valueOf(Where.class, value));
                                        } else if (desc.equals(Constants.KIND_DESC)) {
                                            loc.setValue(Enum.valueOf(Kind.class, value));
                                        }
                                    }

                                    @Override
                                    public void visit(String name, Object value) {
                                        if (name.equals("clazz")) {
                                            loc.setClazz((String)value);
                                        } else if (name.equals("method")) {
                                            loc.setMethod((String)value);
                                        } else if (name.equals("type")) {
                                            loc.setType((String)value);
                                        } else if (name.equals("field")) {
                                            loc.setField((String)value);
                                        } else if (name.equals("line")) {
                                            loc.setLine(((Number)value).intValue());
                                        }
                                    }

                                    @Override
                                    public void visitEnd() {
                                        om.setLocation(loc);
                                    }
                                };
                            }
                            return super.visitAnnotation(name, desc);
                        }
                    };
                }
                if (desc.equals(Constants.ONPROBE_DESC)) {
                    final OnProbe op = new OnProbe();
                    Verifier.this.onProbes.add(op);
                    op.setTargetName(methodName);
                    op.setTargetDescriptor(methodDesc);
                    return new NullVisitor(){

                        @Override
                        public void visit(String name, Object value) {
                            if (name.equals("namespace")) {
                                op.setNamespace((String)value);
                            } else if (name.equals("name")) {
                                op.setName((String)value);
                            }
                        }
                    };
                }
                return new NullVisitor();
            }
        };
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.reportError("no.outer.class");
    }

    void reportError(String err) {
        this.reportError(err, null);
    }

    void reportError(String err, String msg) {
        if (this.unsafe) {
            return;
        }
        String str = Messages.get(err);
        if (msg != null) {
            str = str + ": " + msg;
        }
        throw new VerifierException(str);
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Verifier.usage("java com.sun.btrace.runtime.Verifier <.class file>");
        }
        args[0] = args[0].replace('.', '/');
        File file = new File(args[0] + ".class");
        if (!file.exists()) {
            Verifier.usage("file '" + args[0] + ".class' does not exist");
        }
        FileInputStream fis = new FileInputStream(file);
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        Verifier verifier = new Verifier(new NullVisitor());
        reader.accept(verifier, 0);
    }
}

