/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.client.ClientWrapper;
import org.glassfish.main.itest.tools.asadmin.Asadmin;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class GlassFishTestEnvironment {
    private static final Logger LOG = Logger.getLogger(GlassFishTestEnvironment.class.getName());
    private static final File BASEDIR = GlassFishTestEnvironment.detectBasedir();
    private static final File GF_ROOT = GlassFishTestEnvironment.resolveGlassFishRoot();
    private static final String ADMIN_USER = "admin";
    private static final String ADMIN_PASSWORD = "admintest";
    private static final File ASADMIN = GlassFishTestEnvironment.findAsadmin();
    private static final File PASSWORD_FILE_FOR_UPDATE = GlassFishTestEnvironment.findPasswordFile("password_update.txt");
    private static final File PASSWORD_FILE = GlassFishTestEnvironment.findPasswordFile("password.txt");
    private static final int ASADMIN_START_DOMAIN_TIMEOUT = 30000;

    public static Asadmin getAsadmin() {
        return new Asadmin(ASADMIN, ADMIN_USER, PASSWORD_FILE);
    }

    public static File getTargetDirectory() {
        return new File(BASEDIR, "target");
    }

    public static Path getDomain1Directory() {
        return GF_ROOT.toPath().resolve(Paths.get("domains", "domain1"));
    }

    public static ClientWrapper createClient() {
        return new ClientWrapper(new HashMap(), ADMIN_USER, ADMIN_PASSWORD);
    }

    public static HttpURLConnection openConnection(String context) throws IOException {
        HttpURLConnection connection = GlassFishTestEnvironment.openConnection(4848, context);
        connection.setAuthenticator(new DasAuthenticator());
        return connection;
    }

    public static HttpURLConnection openConnection(int port, String context) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL("http://localhost:" + port + context).openConnection();
        connection.setRequestProperty("X-Requested-By", "JUnit5Test");
        return connection;
    }

    public static void deleteJobsFile() {
        Path path = GF_ROOT.toPath().resolve(Paths.get("domains", "domain1", "config", "jobs.xml"));
        LOG.log(Level.CONFIG, "Deleting: " + path);
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static File detectBasedir() {
        String basedir = System.getProperty("basedir");
        if (basedir != null) {
            return new File(basedir);
        }
        File target = new File("target");
        if (target.exists()) {
            return target.getAbsoluteFile().getParentFile();
        }
        return new File(".").getAbsoluteFile().getParentFile();
    }

    private static File resolveGlassFishRoot() {
        File gfDir = BASEDIR.toPath().resolve(Path.of("target", "glassfish7", "glassfish")).toFile();
        if (gfDir == null || !gfDir.exists()) {
            throw new IllegalStateException("The expected GlassFish home directory doesn't exist: " + gfDir);
        }
        return gfDir;
    }

    private static File findAsadmin() {
        return new File(GF_ROOT, GlassFishTestEnvironment.isWindows() ? "bin/asadmin.bat" : "bin/asadmin");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private static File findPasswordFile(String filename) {
        File output = new File(GlassFishTestEnvironment.getTargetDirectory(), filename);
        if (output.exists()) {
            return output;
        }
        try {
            Enumeration<URL> urls = Asadmin.class.getClassLoader().getResources(filename);
            if (urls == null || !urls.hasMoreElements()) {
                throw new IllegalStateException(filename + " not found");
            }
            if (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (InputStream input = url.openStream();){
                    Files.copy(input, output.toPath(), new CopyOption[0]);
                }
                return output;
            }
            throw new IllegalStateException(filename + " not found");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void changePassword() {
        Asadmin asadmin = new Asadmin(ASADMIN, ADMIN_USER, PASSWORD_FILE_FOR_UPDATE);
        AsadminResult result = asadmin.exec(5000, "change-admin-password");
        if (result.isError()) {
            System.out.println("Admin password NOT changed.");
        } else {
            System.out.println("Admin password changed.");
        }
    }

    static {
        LOG.log(Level.INFO, "Using basedir: {0}", BASEDIR);
        LOG.log(Level.INFO, "Expected GlassFish directory: {0}", GF_ROOT);
        GlassFishTestEnvironment.changePassword();
        Thread hook = new Thread(() -> GlassFishTestEnvironment.getAsadmin().exec(10000, "stop-domain", "--kill", "--force"));
        Runtime.getRuntime().addShutdownHook(hook);
        Asadmin asadmin = GlassFishTestEnvironment.getAsadmin().withEnv(ADMIN_USER, ADMIN_PASSWORD);
        if (System.getenv("AS_START_TIMEOUT") == null) {
            asadmin.withEnv("AS_START_TIMEOUT", Integer.toString(25000));
        }
        MatcherAssert.assertThat((Object)asadmin.exec(30000, "start-domain", "--debug"), (Matcher)AsadminResultMatcher.asadminOK());
    }

    private static class DasAuthenticator
    extends Authenticator {
        private DasAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(GlassFishTestEnvironment.ADMIN_USER, GlassFishTestEnvironment.ADMIN_PASSWORD.toCharArray());
        }
    }
}

