/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import java.util.Comparator;
import java.util.Objects;

public class KeyAndValue<T>
implements Comparable<KeyAndValue<?>> {
    private static final Comparator<Object> NULL_SAFE_COMPARATOR = Comparator.comparing(o -> o == null ? "" : o.toString(), String::compareTo);
    private final String key;
    private final T value;

    public KeyAndValue(String key, T value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof KeyAndValue) {
            KeyAndValue another = (KeyAndValue)object;
            return Objects.equals(this.key, another.key) && Objects.equals(this.value, another.value);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(KeyAndValue<?> o) {
        int keysComparisonResult = this.key.compareTo(o.key);
        if (keysComparisonResult != 0) {
            return keysComparisonResult;
        }
        return Objects.compare(this.value, o.value, NULL_SAFE_COMPARATOR);
    }
}

