/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyTool {
    private static final System.Logger LOG = System.getLogger(KeyTool.class.getName());
    private final File keytool;

    public KeyTool(File keytool) {
        this.keytool = keytool;
    }

    public void exec(String ... args) {
        int exitCode;
        List<String> parameters = Arrays.asList(args);
        LOG.log(System.Logger.Level.INFO, "exec(args={0})", parameters);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.keytool.getAbsolutePath());
        command.add("-noprompt");
        command.addAll(parameters);
        ProcessManager processManager = new ProcessManager(command);
        processManager.setTimeoutMsec(60000);
        processManager.setEcho(true);
        String asadminErrorMessage = "";
        try {
            exitCode = processManager.execute();
        }
        catch (ProcessManagerTimeoutException e) {
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        catch (ProcessManagerException e) {
            LOG.log(System.Logger.Level.ERROR, "The execution failed.", (Throwable)e);
            asadminErrorMessage = e.getMessage();
            exitCode = 1;
        }
        String stdErr = processManager.getStderr() + "\n" + asadminErrorMessage;
        if (!processManager.getStdout().isEmpty()) {
            System.out.println(processManager.getStdout());
        }
        if (!processManager.getStderr().isEmpty()) {
            System.err.println(processManager.getStderr());
        }
        if (exitCode != 0) {
            throw new RuntimeException(stdErr);
        }
    }

    public static KeyStore loadKeyStore(File inputFile, char[] password) {
        try {
            return KeyStore.getInstance(inputFile, password);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Could not load the keystore from " + inputFile, e);
        }
    }
}

