/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.glassfish.main.itest.tools.asadmin.Asadmin;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class DomainSettings {
    private final Asadmin asadmin;
    List<String> settingsBackup = new ArrayList<String>();

    public DomainSettings(Asadmin asadmin) {
        this.asadmin = asadmin;
    }

    public void backupSettings(String getKey) {
        AsadminResult result = this.asadmin.exec(5000, "get", getKey);
        Stream.of(result.getStdOut().split("\n")).filter(line -> line.contains("=")).filter(line -> !line.startsWith("resources.jdbc-connection-pool") || !line.contains(".name=")).forEach(this.settingsBackup::add);
    }

    public void restoreSettings() {
        String[] args = new String[this.settingsBackup.size() + 1];
        args[0] = "set";
        for (int i = 1; i < args.length; ++i) {
            args[i] = this.settingsBackup.get(i - 1);
        }
        this.settingsBackup.clear();
        AsadminResult result = this.asadmin.exec(5000, args);
        MatcherAssert.assertThat((Object)result, (Matcher)AsadminResultMatcher.asadminOK());
    }

    public void backupDerbyPoolSettings() {
        this.backupSettings("resources.jdbc-connection-pool.DerbyPool.*");
    }

    public void setDerbyPoolEmbededded() {
        AsadminResult result = this.asadmin.exec(5000, "set", "resources.jdbc-connection-pool.DerbyPool.datasource-classname=org.apache.derby.jdbc.EmbeddedDataSource", "resources.jdbc-connection-pool.DerbyPool.property.PortNumber=", "resources.jdbc-connection-pool.DerbyPool.property.serverName=", "resources.jdbc-connection-pool.DerbyPool.property.URL=");
        MatcherAssert.assertThat((Object)result, (Matcher)AsadminResultMatcher.asadminOK());
        this.asadmin.exec(5000, "get", "resources.jdbc-connection-pool.DerbyPool.*");
    }
}

