/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.io.File;
import java.util.Map;
import org.glassfish.admin.rest.client.ClientWrapper;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.main.itest.tools.GlassFishTestEnvironment;

public class DomainAdminRestClient
implements Closeable {
    private final ClientWrapper client;
    private final String baseUrl;
    private final String responseType;

    public DomainAdminRestClient(String baseUrl) {
        this(baseUrl, "application/json");
    }

    public DomainAdminRestClient(String baseUrl, String responseType) {
        this(GlassFishTestEnvironment.createClient(), baseUrl, responseType);
    }

    public DomainAdminRestClient(ClientWrapper client, String baseUrl, String responseType) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.responseType = responseType;
    }

    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public Response options(String relativePath) {
        return (Response)this.getRequestBuilder(relativePath).options(Response.class);
    }

    public Response get(String relativePath) {
        return this.get(relativePath, null);
    }

    public Response get(String relativePath, Map<String, String> queryParams) {
        WebTarget target = this.getTarget(relativePath, queryParams);
        return (Response)target.request(new String[]{this.responseType}).get(Response.class);
    }

    public <T> Response put(String relativePath, Entity<T> entityPayload) {
        return (Response)this.getRequestBuilder(relativePath).put(entityPayload, Response.class);
    }

    public Response post(String relativePath) {
        return (Response)this.getRequestBuilder(relativePath).post(Entity.entity(null, (String)"application/x-www-form-urlencoded"), Response.class);
    }

    public Response post(String relativePath, Map<String, String> payload) {
        return this.post(relativePath, this.buildMultivaluedMap(payload));
    }

    public Response post(String relativePath, MultivaluedMap<String, String> payload) {
        return (Response)this.getRequestBuilder(relativePath).post(Entity.entity(payload, (String)"application/x-www-form-urlencoded"), Response.class);
    }

    public <T> Response post(String relativePath, Entity<T> entityPayload) {
        return (Response)this.getRequestBuilder(relativePath).post(entityPayload, Response.class);
    }

    public Response postWithUpload(String relativePath, Map<String, Object> payload) {
        FormDataMultiPart form = new FormDataMultiPart();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            if (entry.getValue() instanceof File) {
                form.getBodyParts().add(new FileDataBodyPart(entry.getKey(), (File)entry.getValue()));
                continue;
            }
            form.field(entry.getKey(), entry.getValue(), MediaType.TEXT_PLAIN_TYPE);
        }
        return (Response)this.getRequestBuilder(relativePath).post(Entity.entity((Object)form, (String)"multipart/form-data"), Response.class);
    }

    public Response delete(String relativePath) {
        return this.delete(relativePath, null);
    }

    public Response delete(String relativePath, Map<String, String> queryParams) {
        WebTarget target = this.getTarget(relativePath, queryParams);
        return (Response)target.request(new String[]{this.responseType}).delete(Response.class);
    }

    public Invocation.Builder getRequestBuilder(String relativePath) {
        return this.getRequestBuilder(relativePath, null);
    }

    public Invocation.Builder getRequestBuilder(String relativePath, Map<String, String> queryParams) {
        return this.getTarget(relativePath, queryParams).request(new String[]{this.responseType});
    }

    public WebTarget getTarget(String relativePath, Map<String, String> queryParams) {
        WebTarget target = this.client.target(this.baseUrl + relativePath);
        if (queryParams == null) {
            return target;
        }
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return target;
    }

    @Override
    public void close() {
        this.client.close();
    }

    private MultivaluedMap<String, String> buildMultivaluedMap(Map<String, String> payload) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        if (payload != null) {
            for (Map.Entry<String, String> entry : payload.entrySet()) {
                formData.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return formData;
    }
}

