/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.main.itest.tools.GlassFishTestEnvironment;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class CollectLogFiles {
    private AsadminResult result;
    private File fileWithLogs;

    public CollectLogFiles collect() throws IOException {
        this.result = GlassFishTestEnvironment.getAsadmin().exec("collect-log-files");
        MatcherAssert.assertThat((Object)this.result, (Matcher)AsadminResultMatcher.asadminOK());
        String path = StringUtils.substringBetween((String)this.result.getStdOut(), (String)"Created Zip file under ", (String)".\n");
        MatcherAssert.assertThat((String)("zip file path parsed from " + this.result.getStdOut()), (Object)path, (Matcher)CoreMatchers.notNullValue());
        this.fileWithLogs = new File(path);
        this.fileWithLogs.deleteOnExit();
        MatcherAssert.assertThat((Object)this.fileWithLogs.getName(), (Matcher)CoreMatchers.endsWith((String)".zip"));
        return this;
    }

    public List<String> getServerLogLines() throws IOException {
        return this.getLogLines("logs/server/server.log");
    }

    private List<String> getLogLines(String logFilePath) throws IOException {
        ZipFile zipFile = new ZipFile(this.fileWithLogs);
        ZipEntry entry = zipFile.getEntry(logFilePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        ArrayList<String> lines = new ArrayList<String>();
        while (reader.ready()) {
            lines.add(reader.readLine());
        }
        return lines;
    }
}

