/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.glassfish.main.itest.tools.GlassFishTestEnvironment;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class FormAuthHttpClient {
    private final URL baseUrl;
    private final String user;
    private final String password;
    private final CookieManager cookieManager;

    public static String readResponseBody(HttpURLConnection connection) throws IOException {
        try (InputStream is = connection.getInputStream();){
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public FormAuthHttpClient(URL baseUrl, String user, String password) {
        this.baseUrl = baseUrl;
        this.user = user;
        this.password = password;
        this.cookieManager = new CookieManager();
        CookieHandler.setDefault(this.cookieManager);
    }

    public HttpURLConnection get(String relativePath) throws IOException {
        HttpCookie sessionId = this.createSession(relativePath);
        HttpURLConnection connection = GlassFishTestEnvironment.openConnection(this.baseUrl.getPort(), this.baseUrl.getPath() + "/j_security_check");
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Cookie", "JSESSIONID=" + URLEncoder.encode(sessionId.getValue(), StandardCharsets.UTF_8));
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Charset", StandardCharsets.UTF_8.name());
        try (DataOutputStream stream = new DataOutputStream(connection.getOutputStream());){
            stream.writeBytes("j_username=" + this.user + "&j_password=" + this.password);
            stream.flush();
        }
        return connection;
    }

    private HttpCookie createSession(String relativePath) throws IOException {
        HttpURLConnection connection = GlassFishTestEnvironment.openConnection(this.baseUrl.getPort(), this.baseUrl.getPath() + "/" + relativePath);
        connection.setRequestMethod("GET");
        MatcherAssert.assertThat((Object)connection.getResponseCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        try {
            HttpCookie httpCookie;
            block9: {
                InputStream is = connection.getInputStream();
                try {
                    String text = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    MatcherAssert.assertThat((Object)text, (Matcher)Matchers.stringContainsInOrder((String[])new String[]{"<title>Login Page</title>", "Please login", "j_username", "j_password"}));
                    HttpCookie sessionId = this.cookieManager.getCookieStore().getCookies().stream().filter(c -> c.getName().equals("JSESSIONID")).findFirst().get();
                    is.readAllBytes();
                    httpCookie = sessionId;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return httpCookie;
        }
        finally {
            connection.disconnect();
        }
    }
}

