/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.itest.tools.asadmin;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.main.itest.tools.GlassFishTestEnvironment;
import org.glassfish.main.itest.tools.asadmin.AsadminResult;
import org.glassfish.main.itest.tools.asadmin.AsadminResultMatcher;
import org.hamcrest.MatcherAssert;

public class DomainPropertiesBackup {
    private final List<String> settingsBackup;

    public DomainPropertiesBackup(String keyFilter, String ... excludedKeys) {
        AsadminResult result = GlassFishTestEnvironment.getAsadmin(true).exec(5000, "get", keyFilter);
        MatcherAssert.assertThat((Object)result, AsadminResultMatcher.asadminOK());
        Predicate<String> inclusionFilter = s -> {
            for (String key : excludedKeys) {
                if (!s.startsWith(key + "=")) continue;
                return false;
            }
            return true;
        };
        this.settingsBackup = Stream.of(result.getStdOut().split("\n")).filter(inclusionFilter).collect(Collectors.toList());
    }

    public void restore() {
        String[] args = new String[this.settingsBackup.size() + 1];
        args[0] = "set";
        for (int i = 1; i < args.length; ++i) {
            args[i] = this.settingsBackup.get(i - 1);
        }
        AsadminResult result = GlassFishTestEnvironment.getAsadmin(true).exec(5000, args);
        MatcherAssert.assertThat((Object)result, AsadminResultMatcher.asadminOK());
    }

    public static DomainPropertiesBackup backupDerbyPool() {
        return new DomainPropertiesBackup("resources.jdbc-connection-pool.DerbyPool.*", "resources.jdbc-connection-pool.DerbyPool.name");
    }
}

