/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.cfg;

import java.io.File;
import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class ConfigurationHelper {
    public static final LoggingPropertyErrorHandler ERROR_HANDLER_PRINT_TO_STDERR = (k, v, e) -> GlassFishLoggingTracer.error(ConfigurationHelper.class, "Invalid value for the key: " + k + ": " + v, e);
    private static final Function<String, Character> STR_TO_CHAR = v -> v == null || v.isEmpty() ? null : Character.valueOf(v.charAt(0));
    private static final Function<String, Boolean> STR_TO_BOOL = v -> {
        if (v == null || v.isEmpty()) {
            return null;
        }
        if ("true".equals(v)) {
            return true;
        }
        if ("false".equals(v)) {
            return false;
        }
        throw new IllegalArgumentException("Value is not a boolean: " + v);
    };
    private static final Function<String, Integer> STR_TO_POSITIVE_INT = v -> {
        Integer value = Integer.valueOf(v);
        if (value >= 0) {
            return value;
        }
        throw new NumberFormatException("Value must be higher or equal to zero!");
    };
    private static final Function<String, DateTimeFormatter> STR_TO_DF = v -> {
        DateTimeFormatter df = DateTimeFormatter.ofPattern(v);
        df.format(OffsetDateTime.now());
        return df;
    };
    private static final Function<String, List<String>> STR_TO_LIST = v -> {
        if (v == null || v.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(v.split("[\\s]*,[\\s]*"));
    };
    private final LogManager manager = LogManager.getLogManager();
    private final String prefix;
    private final LoggingPropertyErrorHandler errorHandler;

    public ConfigurationHelper(String prefix, LoggingPropertyErrorHandler errorHandler) {
        this.prefix = prefix == null ? "" : prefix;
        this.errorHandler = errorHandler;
    }

    public String getString(LogProperty key, String defaultValue) {
        return this.parse(key, defaultValue, Function.identity());
    }

    public Character getCharacter(LogProperty key, Character defaultValue) {
        return this.parse(key, defaultValue, STR_TO_CHAR);
    }

    public Integer getInteger(LogProperty key, Integer defaultValue) {
        return this.parse(key, defaultValue, Integer::valueOf);
    }

    public Integer getNonNegativeInteger(LogProperty key, Integer defaultValue) {
        return this.parse(key, defaultValue, STR_TO_POSITIVE_INT);
    }

    public Boolean getBoolean(LogProperty key, Boolean defaultValue) {
        return this.parse(key, defaultValue, STR_TO_BOOL);
    }

    public Level getLevel(LogProperty key, Level defaultValue) {
        return this.parse(key, defaultValue, Level::parse);
    }

    public File getFile(LogProperty key, File defaultValue) {
        return this.parse(key, defaultValue, File::new);
    }

    public DateTimeFormatter getDateTimeFormatter(LogProperty key, DateTimeFormatter defaultValue) {
        return this.parse(key, defaultValue, STR_TO_DF);
    }

    public Charset getCharset(LogProperty key, Charset defaultValue) {
        return this.parse(key, defaultValue, Charset::forName);
    }

    public List<String> getList(LogProperty key, String defaultValue) {
        return this.parseOrSupply(key, () -> STR_TO_LIST.apply(defaultValue), STR_TO_LIST);
    }

    protected <T> T parse(LogProperty key, T defaultValue, Function<String, T> converter) {
        Supplier<Object> defaultValueSupplier = () -> defaultValue;
        return (T)this.parseOrSupply(key, defaultValueSupplier, converter);
    }

    protected <T> T parseOrSupply(LogProperty key, Supplier<T> defaultValueSupplier, Function<String, T> converter) {
        String realKey = key.getPropertyFullName(this.prefix);
        String property = this.getProperty(realKey);
        if (property == null) {
            return defaultValueSupplier.get();
        }
        try {
            return converter.apply(property);
        }
        catch (Exception e) {
            this.handleError(e, realKey, property);
            return defaultValueSupplier.get();
        }
    }

    protected void handleError(Exception cause, String key, Object property) {
        if (this.errorHandler != null) {
            this.errorHandler.handle(key, property, cause);
        }
    }

    private String getProperty(String key) {
        String value = this.manager.getProperty(key);
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    @FunctionalInterface
    public static interface LoggingPropertyErrorHandler {
        public void handle(String var1, Object var2, Exception var3);
    }
}

