/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.time.OffsetDateTime;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.formatter.ExcludeFieldsSupport;
import org.glassfish.main.jul.formatter.FormatterConfigurationHelper;
import org.glassfish.main.jul.formatter.GlassFishLogFormatter;
import org.glassfish.main.jul.formatter.HandlerId;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class ODLLogFormatter
extends GlassFishLogFormatter {
    private static final int REC_BUFFER_CAPACITY = 512;
    private static final String FIELD_BEGIN_MARKER = "[";
    private static final String FIELD_END_MARKER = "]";
    private static final String DEFAULT_FIELD_SEPARATOR = " ";
    private static final String MULTILINE_INDENTATION = "  ";
    private static final String LABEL_CLASSNAME = "CLASSNAME";
    private static final String LABEL_METHODNAME = "METHODNAME";
    private static final String LABEL_RECORDNUMBER = "RECORDNUMBER";
    private final ExcludeFieldsSupport excludeFieldsSupport = new ExcludeFieldsSupport();
    private String fieldSeparator = " ";
    private boolean multiline = true;

    public ODLLogFormatter(HandlerId handlerId) {
        super(handlerId);
        ODLLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
        ODLLogFormatter.configure(this, FormatterConfigurationHelper.forHandlerId(handlerId));
    }

    public ODLLogFormatter() {
        ODLLogFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
    }

    private static void configure(ODLLogFormatter formatter, FormatterConfigurationHelper helper) {
        formatter.setExcludeFields(helper.getString(ODLFormatterProperty.EXCLUDED_FIELDS, formatter.excludeFieldsSupport.toString()));
        formatter.multiline = helper.getBoolean(ODLFormatterProperty.MULTILINE, formatter.multiline);
        formatter.fieldSeparator = helper.getString(ODLFormatterProperty.FIELD_SEPARATOR, formatter.fieldSeparator);
    }

    @Override
    public String formatRecord(LogRecord record) {
        return this.formatGlassFishLogRecord(MSG_RESOLVER.resolve(record));
    }

    public void setExcludeFields(String excludeFields) {
        this.excludeFieldsSupport.setExcludedFields(excludeFields);
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    private String formatGlassFishLogRecord(GlassFishLogRecord record) {
        try {
            String message = this.getPrintedMessage(record);
            if (message == null) {
                return "";
            }
            boolean forceMultiline = this.multiline || message.contains(System.lineSeparator());
            Level logLevel = record.getLevel();
            String msgId = record.getMessageKey();
            String loggerName = record.getLoggerName();
            String threadName = record.getThreadName();
            StringBuilder output = new StringBuilder(512);
            this.appendTimestamp(output, record.getTime());
            this.appendProductId(output);
            this.appendLogLevel(output, logLevel);
            this.appendMessageKey(output, msgId);
            this.appendLoggerName(output, loggerName);
            this.appendThread(output, record.getThreadID(), threadName);
            this.appendLogLevelAsInt(output, logLevel);
            this.appendSequenceNumber(output, record.getSequenceNumber());
            this.appendSource(output, record.getSourceClassName(), record.getSourceMethodName());
            if (forceMultiline) {
                output.append(FIELD_BEGIN_MARKER).append(FIELD_BEGIN_MARKER);
                output.append(System.lineSeparator());
                output.append(MULTILINE_INDENTATION);
            }
            output.append(message);
            if (forceMultiline) {
                output.append(FIELD_END_MARKER).append(FIELD_END_MARKER);
            }
            output.append(System.lineSeparator()).append(System.lineSeparator());
            return output.toString();
        }
        catch (Exception e) {
            GlassFishLoggingTracer.error(this.getClass(), "Error in formatting Logrecord", e);
            return record.getMessage();
        }
    }

    private void appendTimestamp(StringBuilder output, OffsetDateTime timestamp) {
        output.append(FIELD_BEGIN_MARKER);
        output.append(this.getTimestampFormatter().format(timestamp));
        output.append(FIELD_END_MARKER).append(this.fieldSeparator);
    }

    private void appendProductId(StringBuilder output) {
        output.append(FIELD_BEGIN_MARKER);
        String productId = LoggingSystemEnvironment.getProductId();
        if (productId != null) {
            output.append(productId);
        }
        output.append(FIELD_END_MARKER).append(this.fieldSeparator);
    }

    private void appendLogLevel(StringBuilder output, Level logLevel) {
        output.append(FIELD_BEGIN_MARKER);
        output.append(logLevel.getName());
        output.append(FIELD_END_MARKER).append(this.fieldSeparator);
    }

    private void appendMessageKey(StringBuilder output, String msgId) {
        output.append(FIELD_BEGIN_MARKER);
        if (msgId != null) {
            output.append(msgId);
        }
        output.append(FIELD_END_MARKER).append(this.fieldSeparator);
    }

    private void appendLoggerName(StringBuilder output, String loggerName) {
        output.append(FIELD_BEGIN_MARKER);
        if (loggerName != null) {
            output.append(loggerName);
        }
        output.append(FIELD_END_MARKER).append(this.fieldSeparator);
    }

    private void appendThread(StringBuilder output, int threadId, String threadName) {
        if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
            output.append(FIELD_BEGIN_MARKER);
            output.append("tid: ").append("_ThreadID=").append(threadId).append(" _ThreadName=").append(threadName);
            output.append(FIELD_END_MARKER).append(this.fieldSeparator);
        }
    }

    private void appendLogLevelAsInt(StringBuilder output, Level logLevel) {
        if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
            output.append(FIELD_BEGIN_MARKER);
            output.append("levelValue: ").append(logLevel.intValue());
            output.append(FIELD_END_MARKER).append(this.fieldSeparator);
        }
    }

    private void appendSequenceNumber(StringBuilder output, long sequenceNumber) {
        if (this.isPrintSequenceNumber()) {
            output.append(FIELD_BEGIN_MARKER);
            output.append(LABEL_RECORDNUMBER).append(": ").append(sequenceNumber);
            output.append(FIELD_END_MARKER).append(this.fieldSeparator);
        }
    }

    private void appendSource(StringBuilder output, String className, String methodName) {
        if (!this.isPrintSource()) {
            return;
        }
        if (className != null) {
            output.append(FIELD_BEGIN_MARKER);
            output.append(LABEL_CLASSNAME).append(": ").append(className);
            output.append(FIELD_END_MARKER).append(this.fieldSeparator);
        }
        if (methodName != null) {
            output.append(FIELD_BEGIN_MARKER);
            output.append(LABEL_METHODNAME).append(": ").append(methodName);
            output.append(FIELD_END_MARKER).append(this.fieldSeparator);
        }
    }

    public static enum ODLFormatterProperty implements LogProperty
    {
        EXCLUDED_FIELDS("excludedFields"),
        MULTILINE("multiline"),
        FIELD_SEPARATOR("fieldSeparator");

        private final String propertyName;

        private ODLFormatterProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

