/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.record.GlassFishLogRecord;

final class LoggingOutputStream
extends ByteArrayOutputStream {
    private final String lineSeparator;
    private final Level logRecordLevel;
    private final LogRecordBuffer logRecordBuffer;
    private final String loggerName;
    private final Pump pump;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Charset charset;

    LoggingOutputStream(Logger logger, Level logRecordLevel, int bufferCapacity, Charset charset) {
        this.lineSeparator = System.lineSeparator();
        this.loggerName = logger.getName();
        this.logRecordLevel = logRecordLevel;
        this.charset = charset;
        this.logRecordBuffer = new LogRecordBuffer(bufferCapacity);
        this.pump = new Pump(logger, this.logRecordBuffer);
    }

    void addRecord(Throwable throwable) {
        if (this.closed.get()) {
            return;
        }
        GlassFishLogRecord logRecord = new GlassFishLogRecord(this.logRecordLevel, "");
        logRecord.setThrown(throwable);
        logRecord.setLoggerName(this.loggerName);
        this.logRecordBuffer.add(logRecord);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed.get()) {
            return;
        }
        String logMessage = this.getMessage();
        if (logMessage.isEmpty() || this.lineSeparator.equals(logMessage)) {
            return;
        }
        GlassFishLogRecord logRecord = new GlassFishLogRecord(this.logRecordLevel, logMessage);
        logRecord.setLoggerName(this.loggerName);
        this.logRecordBuffer.add(logRecord);
    }

    private synchronized String getMessage() throws IOException {
        super.flush();
        String logMessage = super.toString(this.charset).trim();
        super.reset();
        return logMessage;
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        this.pump.shutdown();
        super.close();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " redirecting messages to the logger " + this.loggerName;
    }

    private static final class Pump
    extends Thread {
        private final LogRecordBuffer buffer;
        private final Logger logger;

        private Pump(Logger logger, LogRecordBuffer buffer) {
            this.buffer = buffer;
            this.logger = logger;
            this.setName("Logging pump for '" + logger.getName() + "'");
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.logAllPendingRecordsOrWait();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }

        void shutdown() {
            this.interrupt();
            this.logAllPendingRecords();
        }

        private void logAllPendingRecordsOrWait() {
            if (!this.logRecord(this.buffer.pollOrWait())) {
                return;
            }
            this.logAllPendingRecords();
        }

        private void logAllPendingRecords() {
            while (this.logRecord(this.buffer.poll())) {
            }
        }

        private boolean logRecord(LogRecord record) {
            if (record == null) {
                return false;
            }
            this.logger.log(record);
            return true;
        }
    }
}

