/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;

public class LogCollectorHandler
extends Handler {
    private static final MessageResolver RESOLVER = new MessageResolver();
    private final LogRecordBuffer buffer = new LogRecordBuffer(100, 5);
    private final Logger logger;

    public LogCollectorHandler(Logger loggerToFollow) {
        this.logger = loggerToFollow;
        this.logger.addHandler(this);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.buffer.add(RESOLVER.resolve(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.logger.removeHandler(this);
        this.reset();
    }

    public GlassFishLogRecord pop() {
        return this.buffer.poll();
    }

    public List<GlassFishLogRecord> getAll() {
        ArrayList<GlassFishLogRecord> list = new ArrayList<GlassFishLogRecord>(this.buffer.getSize());
        while (!this.buffer.isEmpty()) {
            list.add(this.buffer.poll());
        }
        return list;
    }

    public <R> List<R> getAll(Function<LogRecord, R> mappingFunction) {
        return this.getAll().stream().map(mappingFunction).collect(Collectors.toList());
    }

    public void reset() {
        while (!this.buffer.isEmpty()) {
            this.buffer.poll();
        }
    }
}

