/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class ProxyHelper {
    private static final Object[] NO_ARGS = new Object[0];
    private static final MethodHandle EXCEPTION_HANDLER;
    private static final ClassValue<ConcurrentMap<Method, MethodHandle>> DEFAULT_METHODS_CACHE;

    private ProxyHelper() {
        throw new AssertionError();
    }

    public static Object invokeDefault(Object proxy, Method method, Object ... args) throws Throwable {
        Objects.requireNonNull(proxy);
        Objects.requireNonNull(method);
        Class<?> proxyClass = proxy.getClass();
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException(proxy + " is not a proxy instance");
        }
        if (!method.isDefault()) {
            throw new IllegalArgumentException(method + " is not a default method");
        }
        MethodHandle mh = ProxyHelper.defaultMethodHandle(proxyClass, method);
        try {
            Object[] params = args != null ? args : NO_ARGS;
            return mh.invokeExact(proxy, params);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ProxyInvocationException e) {
            throw e.getCause();
        }
    }

    private static MethodHandle defaultMethodHandle(Class<? extends Proxy> proxyClass, Method method) {
        ConcurrentMap<Method, MethodHandle> defaultMethods = DEFAULT_METHODS_CACHE.get(proxyClass);
        MethodHandle defaultMethodHandle = (MethodHandle)defaultMethods.get(method);
        if (defaultMethodHandle == null) {
            MethodHandle methodHandle;
            MethodType mt = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> proxyIntf = ProxyHelper.findProxyInterface(proxyClass, method);
            try {
                methodHandle = lookup.findSpecial(proxyIntf, method.getName(), mt, proxyClass).asFixedArity();
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            methodHandle = methodHandle.asType(methodHandle.type().changeReturnType(Object.class));
            methodHandle = MethodHandles.catchException(methodHandle, Throwable.class, EXCEPTION_HANDLER);
            methodHandle = methodHandle.asSpreader(1, Object[].class, mt.parameterCount());
            methodHandle = methodHandle.asType(MethodType.methodType(Object.class, Object.class, Object[].class));
            MethodHandle cachedMethodHandle = defaultMethods.putIfAbsent(method, methodHandle);
            defaultMethodHandle = cachedMethodHandle != null ? cachedMethodHandle : methodHandle;
        }
        return defaultMethodHandle;
    }

    private static Class<?> findProxyInterface(Class<? extends Proxy> proxyClass, Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (!declaringClass.isInterface()) {
            throw new IllegalArgumentException(method + " is not declared in the proxy class " + proxyClass.getName());
        }
        return proxyClass.getInterfaces()[0];
    }

    private static Object exceptionHandler(Throwable cause) throws ProxyInvocationException {
        throw new ProxyInvocationException(cause);
    }

    static {
        try {
            EXCEPTION_HANDLER = MethodHandles.lookup().findStatic(ProxyHelper.class, "exceptionHandler", MethodType.methodType(Object.class, Throwable.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        DEFAULT_METHODS_CACHE = new ClassValue<ConcurrentMap<Method, MethodHandle>>(){

            @Override
            protected ConcurrentMap<Method, MethodHandle> computeValue(Class<?> type) {
                return new ConcurrentHashMap<Method, MethodHandle>();
            }
        };
    }

    private static class ProxyInvocationException
    extends ReflectiveOperationException {
        ProxyInvocationException(Throwable cause) {
            super(cause);
        }
    }
}

