/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_get-jdbc-driver-class-names")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class GetJdbcDriverClassNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String dbVendor;
    @Param
    private String resType;
    @Param(defaultValue="true", optional=true)
    private boolean introspect;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Set driverClassNames = this.connectorRuntime.getJdbcDriverClassNames(this.dbVendor, this.resType, this.introspect);
            Properties extraProperties = new Properties();
            extraProperties.put("driverClassNames", new ArrayList(driverClassNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-jdbc-driver-class-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

