/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_get-validation-table-names")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-validation-table-names", description="Get Validation Table Names")})
public class GetValidationTableNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String poolName;
    @Param(name="appname", optional=true)
    private String applicationName;
    @Param(name="modulename", optional=true)
    private String moduleName;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PoolInfo poolInfo = new PoolInfo(this.poolName, this.applicationName, this.moduleName);
            Set validationTableNames = this.connectorRuntime.getValidationTableNames(poolInfo);
            Properties extraProperties = new Properties();
            extraProperties.put("validationTableNames", new ArrayList(validationTableNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-validation-table-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

