/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectionPoolMonitoringExtension;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolAppProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProviderUtil;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolStatsProviderBootstrap;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.pool.monitor.JdbcConnPoolAppProbeProvider;
import org.glassfish.jdbc.pool.monitor.JdbcConnPoolAppStatsProvider;
import org.glassfish.jdbc.pool.monitor.JdbcConnPoolProbeProvider;
import org.glassfish.jdbc.pool.monitor.JdbcConnPoolStatsProvider;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class JdbcPoolMonitoringExtension
implements ConnectionPoolMonitoringExtension {
    @Inject
    private Provider<ConnectionPoolProbeProviderUtil> connectionPoolProbeProviderUtilProvider;
    @Inject
    private Provider<ConnectionPoolStatsProviderBootstrap> connectionPoolStatsProviderBootstrapProvider;
    @Inject
    private PoolManager poolManager;
    private ConnectorRuntime runtime;
    private static final Logger logger = LogDomains.getLogger(JdbcPoolMonitoringExtension.class, (String)"javax.enterprise.resource.resourceadapter");
    private List<JdbcConnPoolStatsProvider> jdbcStatsProviders = new ArrayList<JdbcConnPoolStatsProvider>();
    private List<JdbcConnPoolAppStatsProvider> jdbcPoolAppStatsProviders = new ArrayList<JdbcConnPoolAppStatsProvider>();

    public JdbcPoolMonitoringExtension() {
        this.runtime = ConnectorRuntime.getRuntime();
    }

    public ConnectionPoolProbeProviderUtil getProbeProviderUtil() {
        return (ConnectionPoolProbeProviderUtil)this.connectionPoolProbeProviderUtilProvider.get();
    }

    public void registerPool(PoolInfo poolInfo) {
        if (this.poolManager.getPool(poolInfo) != null) {
            this.getProbeProviderUtil().createJdbcProbeProvider();
            JdbcConnPoolStatsProvider jdbcPoolStatsProvider = new JdbcConnPoolStatsProvider(poolInfo, logger);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)ConnectorsUtil.getPoolMonitoringSubTreeRoot((PoolInfo)poolInfo, (boolean)true), (Object)jdbcPoolStatsProvider);
            PoolLifeCycleListenerRegistry registry = ((ConnectionPoolStatsProviderBootstrap)this.connectionPoolStatsProviderBootstrapProvider.get()).registerPool(poolInfo, this.getProbeProviderUtil().getJdbcProbeProvider());
            jdbcPoolStatsProvider.setPoolRegistry(registry);
            this.jdbcStatsProviders.add(jdbcPoolStatsProvider);
        }
    }

    public void unregisterPool(PoolInfo poolInfo) {
        if (this.jdbcStatsProviders != null) {
            Iterator<JdbcConnPoolStatsProvider> i = this.jdbcStatsProviders.iterator();
            while (i.hasNext()) {
                JdbcConnPoolStatsProvider jdbcPoolStatsProvider = i.next();
                if (!poolInfo.equals((Object)jdbcPoolStatsProvider.getPoolInfo())) continue;
                PoolLifeCycleListenerRegistry poolRegistry = jdbcPoolStatsProvider.getPoolRegistry();
                poolRegistry.unRegisterPoolLifeCycleListener(poolInfo);
                StatsProviderManager.unregister((Object)jdbcPoolStatsProvider);
                i.remove();
            }
        }
        ((ConnectionPoolStatsProviderBootstrap)this.connectionPoolStatsProviderBootstrapProvider.get()).postUnregisterPool(poolInfo);
    }

    public ConnectionPoolAppProbeProvider registerConnectionPool(PoolInfo poolInfo, String appName) {
        JdbcConnPoolAppProbeProvider probeAppProvider = null;
        ResourcePool pool = this.runtime.getConnectionPoolConfig(poolInfo);
        if (pool instanceof JdbcConnectionPool) {
            probeAppProvider = new JdbcConnPoolAppProbeProvider();
            JdbcConnPoolAppStatsProvider jdbcPoolAppStatsProvider = new JdbcConnPoolAppStatsProvider(poolInfo, appName);
            StatsProviderManager.register((String)"jdbc-connection-pool", (PluginPoint)PluginPoint.SERVER, (String)("resources/" + ConnectorsUtil.escapeResourceNameForMonitoring((String)poolInfo.getName()) + "/" + appName), (Object)jdbcPoolAppStatsProvider);
            this.jdbcPoolAppStatsProviders.add(jdbcPoolAppStatsProvider);
        }
        return probeAppProvider;
    }

    public void unRegisterConnectionPool() {
        for (JdbcConnPoolAppStatsProvider jdbcPoolAppStatsProvider : this.jdbcPoolAppStatsProviders) {
            StatsProviderManager.unregister((Object)jdbcPoolAppStatsProvider);
        }
        this.jdbcPoolAppStatsProviders.clear();
    }

    public JdbcConnPoolProbeProvider createProbeProvider() {
        return new JdbcConnPoolProbeProvider();
    }
}

