/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.felixwebconsoleextension;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.glassfish.osgi.felixwebconsoleextension.GlassFishBrandingPlugin;
import org.glassfish.osgi.felixwebconsoleextension.GlassFishSecurityProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class FelixWebConsoleExtensionActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    private BundleContext context;
    private static final String WEBCONSOLE_PID = "org.apache.felix.webconsole.internal.servlet.OsgiManager";
    private static final String PROP_HTTP_SERVICE_SELECTOR = "http.service.filter";
    private static final String PROP_REALM = "realm";
    private static final String REALM = "GlassFish Server";
    private static final String HTTP_SERVICE_SELECTOR = "VirtualServer=server";
    private ServiceTracker tracker;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.registerBrandingPlugin();
        this.configureConsole();
        this.registerWebConsoleSecurityProvider();
    }

    private void registerWebConsoleSecurityProvider() {
        GlassFishSecurityProvider secprovider = new GlassFishSecurityProvider();
        secprovider.setBundleContext(this.context);
        this.context.registerService(WebConsoleSecurityProvider.class.getName(), (Object)secprovider, null);
        this.logger.logp(Level.INFO, "FelixWebConsoleExtensionActivator", "start", "Registered {0}", new Object[]{secprovider});
    }

    private void configureConsole() {
        this.tracker = new ServiceTracker(this.context, ConfigurationAdmin.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                try {
                    ConfigurationAdmin ca = (ConfigurationAdmin)ConfigurationAdmin.class.cast(this.context.getService(reference));
                    Configuration config = null;
                    config = ca.getConfiguration(FelixWebConsoleExtensionActivator.WEBCONSOLE_PID, null);
                    Dictionary old = config.getProperties();
                    Hashtable<String, String> newProps = new Hashtable<String, String>();
                    ((Dictionary)newProps).put(FelixWebConsoleExtensionActivator.PROP_HTTP_SERVICE_SELECTOR, FelixWebConsoleExtensionActivator.HTTP_SERVICE_SELECTOR);
                    ((Dictionary)newProps).put(FelixWebConsoleExtensionActivator.PROP_REALM, FelixWebConsoleExtensionActivator.REALM);
                    if (old != null) {
                        old.remove("service.pid");
                    }
                    if (!((Object)newProps).equals(old)) {
                        if (config.getBundleLocation() != null) {
                            config.setBundleLocation(null);
                        }
                        config.update(newProps);
                    }
                }
                catch (IOException e) {
                    FelixWebConsoleExtensionActivator.this.logger.logp(Level.INFO, "FelixWebConsoleExtensionActivator", "addingService", "Failed to update webconsole configuration", e);
                }
                return null;
            }
        };
        this.tracker.open();
    }

    private void registerBrandingPlugin() {
        GlassFishBrandingPlugin service = new GlassFishBrandingPlugin();
        this.context.registerService(BrandingPlugin.class.getName(), (Object)service, null);
        this.logger.logp(Level.INFO, "FelixWebConsoleExtensionActivator", "start", "Registered {0}", new Object[]{service});
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }
}

