/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.felixwebconsoleextension;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.felix.webconsole.WebConsoleSecurityProvider;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.security.services.api.authentication.AuthenticationService;
import org.osgi.framework.BundleContext;

public class GlassFishSecurityProvider
implements WebConsoleSecurityProvider {
    private BundleContext ctx;
    private GlassFish gf;

    public void setBundleContext(BundleContext context) {
        this.ctx = context;
    }

    private GlassFish getGlassFish() {
        GlassFish gf = (GlassFish)this.ctx.getService(this.ctx.getServiceReference(GlassFish.class.getName()));
        try {
            assert (gf.getStatus() == GlassFish.Status.STARTED);
        }
        catch (GlassFishException e) {
            throw new RuntimeException(e);
        }
        return gf;
    }

    public Object authenticate(String username, String password) {
        this.gf = this.getGlassFish();
        AuthenticationService authService = null;
        try {
            authService = this.getAuthService();
        }
        catch (GlassFishException gfe) {
            gfe.printStackTrace();
            return null;
        }
        Subject fs = null;
        try {
            fs = authService.login(username, password.toCharArray(), fs);
        }
        catch (LoginException e) {
            e.printStackTrace();
            return null;
        }
        return fs;
    }

    private AuthenticationService getAuthService() throws GlassFishException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<AuthenticationService>(){

                @Override
                public AuthenticationService run() throws GlassFishException {
                    return (AuthenticationService)GlassFishSecurityProvider.this.gf.getService(AuthenticationService.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (GlassFishException)((Object)GlassFishException.class.cast(e.getException()));
        }
    }

    public boolean authorize(Object user, String role) {
        return false;
    }
}

