/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.io.ByteArrayOutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.paas.gfplugin.RemoteCommandResult;
import org.jvnet.hk2.component.Habitat;

public class CommandRunnerClient
implements CommandRunner {
    protected static final Logger logger = Logger.getLogger(CLICommand.class.getPackage().getName());
    private Habitat habitat;
    ByteArrayOutputStream output = new ByteArrayOutputStream();

    public CommandRunnerClient(Habitat habitat) {
        Logger.getLogger("").getHandlers()[0].setLevel(Level.OFF);
        Handler handler = new Handler(){

            public void publish(LogRecord record) {
                try {
                    CommandRunnerClient.this.output.write(record.getMessage().getBytes());
                    CommandRunnerClient.this.output.write("\n".getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        };
        logger.addHandler(handler);
        this.habitat = habitat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult run(String s, String ... strings) {
        Object result = null;
        if (s != null) {
            System.out.print("\nPROV/ASSOC/DEPL: CommandRunnerClient running command [" + s + " ");
            if (strings != null) {
                for (String arg : strings) {
                    System.out.print(arg + " ");
                }
            }
            System.out.println("]\n");
        }
        CLICommand cliCommand = this.getCommand(s);
        int size = strings != null ? strings.length + 1 : 1;
        String[] args = new String[size];
        args[0] = s;
        if (size > 1) {
            System.arraycopy(strings, 0, args, 1, strings.length);
        }
        Exception t = null;
        try {
            cliCommand.execute(args);
        }
        catch (Exception ex) {
            t = ex;
        }
        try {
            CommandResult commandResult = this.buildCommandResult(new String(this.output.toByteArray()), t);
            return commandResult;
        }
        finally {
            this.output.reset();
        }
    }

    private CLICommand getCommand(String command) {
        CLICommand cliCommand = (CLICommand)this.habitat.getComponent(CLICommand.class, command);
        if (cliCommand == null) {
            try {
                cliCommand = new RemoteCommand(command, (ProgramOptions)this.habitat.getComponent(ProgramOptions.class), (Environment)this.habitat.getComponent(Environment.class));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return cliCommand;
    }

    private CommandResult buildCommandResult(String outputStr, Throwable failureCause) {
        if (outputStr.trim().length() == 0 && failureCause != null) {
            outputStr = failureCause.getMessage();
        }
        return new RemoteCommandResult(failureCause == null ? 0 : 1, outputStr, failureCause);
    }

    public void setTerse(boolean b) {
    }
}

