/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFishException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerClient
implements Deployer {
    CommandRunner cr;

    DeployerClient(CommandRunner commandRunner) {
        this.cr = commandRunner;
    }

    public String deploy(URI uri, String ... strings) throws GlassFishException {
        return this.deploy(new File(uri), strings);
    }

    public String deploy(File file, String ... strings) throws GlassFishException {
        int size = strings != null ? strings.length + 1 : 1;
        String[] args = new String[size];
        if (size > 1) {
            System.arraycopy(strings, 0, args, 0, size - 1);
        }
        args[size - 1] = file.getAbsolutePath();
        CommandResult result = this.cr.run("deploy", args);
        return result.getOutput();
    }

    public String deploy(InputStream inputStream, String ... strings) throws GlassFishException {
        try {
            return this.deploy(this.createFile(inputStream), strings);
        }
        catch (IOException e) {
            throw new GlassFishException((Throwable)e);
        }
    }

    public void undeploy(String s, String ... strings) throws GlassFishException {
        int size = strings != null ? strings.length + 1 : 1;
        String[] args = new String[size];
        if (size > 1) {
            System.arraycopy(strings, 0, args, 0, size - 1);
        }
        args[size - 1] = s;
        CommandResult result = this.cr.run("undeploy", args);
        System.out.println(result.getOutput());
    }

    public Collection<String> getDeployedApplications() throws GlassFishException {
        ArrayList<String> apps = new ArrayList<String>();
        CommandResult result = this.cr.run("list-components", new String[0]);
        if (result.getOutput().indexOf("<") != -1) {
            Properties properties = new Properties();
            try {
                properties.load(new ByteArrayInputStream(result.getOutput().getBytes()));
                for (Object key : properties.keySet()) {
                    apps.add((String)key);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(InputStream in) throws IOException {
        File file = File.createTempFile("app", "tmp");
        file.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.copyStream(in, out);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        return file;
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }
}

