/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.javaee.core.deployment.DolProvider;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.resources.admin.cli.ResourcesXMLParser;
import org.glassfish.resources.api.Resource;
import org.glassfish.resources.module.ResourcesDeployer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GlassFishCloudArchiveProcessor
implements GlassFishPluginConstants {
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    private DolProvider dolProvider;

    public Set<ServiceReference> getServiceReferences(ReadableArchive cloudArchive, String appName, PaaSDeploymentContext dc) {
        HashSet<ServiceReference> serviceReferences = new HashSet<ServiceReference>();
        HashSet resRefs = new HashSet();
        Application application = null;
        try {
            ApplicationInfo appInfo = this.appRegistry.get(appName);
            if (appInfo != null) {
                application = (Application)appInfo.getMetaData(Application.class);
            }
            if (application == null) {
                application = this.dolProvider.processDeploymentMetaData(cloudArchive);
            }
            if (application == null) {
                return serviceReferences;
            }
            this.scanAndPopulateServiceRefsForDSRefsInPUs(serviceReferences, application);
            for (WebBundleDescriptor descriptor : application.getBundleDescriptors(WebBundleDescriptor.class)) {
                resRefs.addAll(descriptor.getResourceReferenceDescriptors());
            }
            for (WebBundleDescriptor descriptor : application.getBundleDescriptors(EjbBundleDescriptor.class)) {
                resRefs.addAll(descriptor.getResourceReferenceDescriptors());
            }
            for (WebBundleDescriptor descriptor : application.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                resRefs.addAll(descriptor.getResourceReferenceDescriptors());
            }
            HashSet<String> resRefNames = new HashSet<String>();
            HashSet<ResourceReferenceDescriptor> mappedNameSet = new HashSet<ResourceReferenceDescriptor>();
            HashSet<ResourceReferenceDescriptor> filteredResRefSet = new HashSet<ResourceReferenceDescriptor>();
            for (ResourceReferenceDescriptor resRef : resRefs) {
                if (resRef.getMappedName() != null && !resRef.getMappedName().isEmpty()) {
                    mappedNameSet.add(resRef);
                    continue;
                }
                if (resRef.getJndiName() == null) continue;
                resRefNames.add(resRef.getJndiName());
                filteredResRefSet.add(resRef);
            }
            for (ResourceReferenceDescriptor resRef : mappedNameSet) {
                if (resRefNames.contains(resRef.getMappedName())) continue;
                filteredResRefSet.add(resRef);
            }
            HashMap<String, String> serviceNameRefs = new HashMap<String, String>();
            ArrayList nonConnectorResources = new ArrayList();
            HashMap<Resource, ResourcesXMLParser> resourceXmlParsers = new HashMap<Resource, ResourcesXMLParser>();
            ResourcesDeployer.getResources((ReadableArchive)cloudArchive, (String)appName, null, nonConnectorResources, resourceXmlParsers);
            for (Resource res : nonConnectorResources) {
                if (!res.getType().equals("jdbc-resource")) continue;
                Resource poolRes = this.getConnectionPool(res, resourceXmlParsers);
                String serviceName = (String)poolRes.getProperties().get("service-name");
                String refName = (String)res.getAttributes().get("jndi-name");
                if (serviceName == null) continue;
                serviceNameRefs.put(refName, serviceName);
            }
            for (ResourceReferenceDescriptor resRef : filteredResRefSet) {
                ServiceReference ref = new ServiceReference(resRef.getName(), resRef.getType(), null, resRef.getSchemaGeneratorProperties());
                ref.setServiceName((String)serviceNameRefs.get(resRef.getName()));
                serviceReferences.add(ref);
            }
            if (dc != null) {
                dc.addTransientAppMetaData("resourceXmlParsers", resourceXmlParsers);
                dc.addTransientAppMetaData("nonConnectorResources", nonConnectorResources);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serviceReferences;
    }

    public Resource getConnectionPool(Resource forResource, Map<Resource, ResourcesXMLParser> resourceXmlParsers) {
        Set<Resource> resources = resourceXmlParsers.keySet();
        String poolName = (String)forResource.getAttributes().get("pool-name");
        for (Resource res : resources) {
            if (!res.getType().equals("jdbc-connection-pool") || !res.getAttributes().get("name").equals(poolName)) continue;
            return res;
        }
        return null;
    }

    private void scanAndPopulateServiceRefsForDSRefsInPUs(Set<ServiceReference> serviceReferences, Application application) {
        Set bundleDescriptors = application.getBundleDescriptors();
        HashSet<String> jndiNames = new HashSet<String>();
        if (bundleDescriptors != null) {
            for (BundleDescriptor bundleDescriptor : bundleDescriptors) {
                Collection puDescriptors = bundleDescriptor.findReferencedPUs();
                for (PersistenceUnitDescriptor pud : puDescriptors) {
                    if (pud.getJtaDataSource() != null) {
                        jndiNames.add(pud.getJtaDataSource());
                    }
                    if (pud.getNonJtaDataSource() == null) continue;
                    jndiNames.add(pud.getNonJtaDataSource());
                }
            }
        }
        for (String jndiName : jndiNames) {
            serviceReferences.add(new ServiceReference(jndiName, "javax.sql.DataSource", null));
        }
    }
}

