/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.util.zip.ZipWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.javaee.core.deployment.JavaEEDeploymentUtils;
import org.glassfish.paas.gfplugin.GlassFishCloudArchiveProcessor;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.gfplugin.GlassFishProvisioner;
import org.glassfish.paas.gfplugin.cli.GlassFishServiceUtil;
import org.glassfish.paas.gfplugin.cli.ProvisionerUtil;
import org.glassfish.paas.gfplugin.customizer.DASProvisioner;
import org.glassfish.paas.gfplugin.customizer.InstanceProvisioner;
import org.glassfish.paas.orchestrator.PaaSDeploymentContext;
import org.glassfish.paas.orchestrator.ServiceOrchestrator;
import org.glassfish.paas.orchestrator.provisioning.ServiceInfo;
import org.glassfish.paas.orchestrator.service.JavaEEServiceType;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.Property;
import org.glassfish.paas.orchestrator.service.metadata.ServiceCharacteristics;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.metadata.ServiceReference;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.orchestrator.service.spi.ServiceProvisioningException;
import org.glassfish.paas.spe.common.ProvisioningFuture;
import org.glassfish.paas.spe.common.ServiceProvisioningEngineBase;
import org.glassfish.resources.admin.cli.ResourcesXMLParser;
import org.glassfish.resources.api.Resource;
import org.glassfish.virtualization.spi.AllocationStrategy;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class GlassFishPlugin
extends ServiceProvisioningEngineBase<JavaEEServiceType>
implements GlassFishPluginConstants {
    @Inject
    private GlassFishCloudArchiveProcessor archiveProcessor;
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private GlassFishServiceUtil gfServiceUtil;
    @Inject
    private ProvisionerUtil provisionerUtil;
    @Inject
    private Domain domain;
    @Inject
    private Habitat habitat;
    @Inject
    private DASProvisioner dasProvisioner;
    @Inject
    private InstanceProvisioner instanceProvisioner;
    private static Logger logger = Logger.getLogger(GlassFishPlugin.class.getName());

    public JavaEEServiceType getServiceType() {
        return new JavaEEServiceType();
    }

    public boolean handles(ReadableArchive cloudArchive) {
        return JavaEEDeploymentUtils.isJavaEE((ReadableArchive)cloudArchive, (Habitat)this.habitat);
    }

    public boolean handles(ServiceDescription serviceDescription) {
        return false;
    }

    public boolean isReferenceTypeSupported(String referenceType) {
        return referenceType.equals("JavaEE");
    }

    public Set<ServiceReference> getServiceReferences(String appName, ReadableArchive cloudArchive, PaaSDeploymentContext dc) {
        return this.archiveProcessor.getServiceReferences(cloudArchive, appName, dc);
    }

    public ServiceDescription getDefaultServiceDescription(String appName, ServiceReference svcRef) {
        return this.generateDefaultServiceDescription(appName);
    }

    public boolean unprovisionService(ServiceDescription serviceDescription, PaaSDeploymentContext dc) {
        ProvisionedService service = this.getProvisionedService(serviceDescription);
        String serviceName = serviceDescription.getName();
        String clusterName = serviceDescription.getVirtualClusterName();
        boolean deleteSuccessful = false;
        for (int currentClusterSize = this.domain.getClusterNamed(clusterName).getInstances().size(); currentClusterSize > 0; --currentClusterSize) {
            serviceDescription.setName(serviceName + "." + currentClusterSize);
            deleteSuccessful = super.deleteService(serviceDescription) || deleteSuccessful;
        }
        serviceDescription.setName(serviceName);
        this.deleteService(serviceDescription);
        this.commandRunner.run("_delete-elastic-service", new String[]{serviceName});
        return deleteSuccessful;
    }

    public ProvisionedService provisionService(ServiceDescription serviceDescription, PaaSDeploymentContext pdc) {
        String serviceName = serviceDescription.getName();
        GlassFishProvisionedService gfps = null;
        if (provisionDAS) {
            ProvisioningFuture future = this.createService(serviceDescription);
            gfps = this.dasProvisioner.provision(future.get());
        } else {
            String dasIPAddress = "localhost";
            Properties serviceProperties = new Properties();
            serviceProperties.setProperty("min.clustersize", serviceDescription.getConfiguration("min.clustersize"));
            serviceProperties.setProperty("max.clustersize", serviceDescription.getConfiguration("max.clustersize"));
            GlassFishProvisioner gfProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(dasIPAddress);
            GlassFish provisionedGlassFish = gfProvisioner.getGlassFish();
            gfps = new GlassFishProvisionedService(serviceDescription, serviceProperties, ServiceStatus.RUNNING, provisionedGlassFish);
        }
        int minClusterSize = Integer.parseInt(serviceDescription.getConfiguration("min.clustersize"));
        ArrayList<ProvisioningFuture> futures = new ArrayList<ProvisioningFuture>();
        for (int i = 0; i < minClusterSize; ++i) {
            ServiceDescription sd = new ServiceDescription(serviceDescription);
            sd.setName(serviceName + "." + (i + 1));
            futures.add(this.createService(sd));
        }
        for (ProvisioningFuture future : futures) {
            ProvisionedService provisionedService = future.get();
            gfps.addChildService(provisionedService);
        }
        if (provisionDAS) {
            this.instanceProvisioner.provision(gfps, gfps.getChildServices().toArray(new ProvisionedService[0]));
        }
        this.commandRunner.run("_create-elastic-service", new String[]{"--min=" + serviceDescription.getConfiguration("min.clustersize"), "--max=" + serviceDescription.getConfiguration("max.clustersize"), serviceName});
        return gfps;
    }

    public ProvisionedService startService(ServiceDescription serviceDescription, ServiceInfo serviceInfo) {
        String serviceName = serviceDescription.getName();
        Properties serviceProperties = new Properties();
        String dasIPAddress = "localhost";
        serviceProperties.setProperty("host", dasIPAddress);
        GlassFishProvisioner gfProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(dasIPAddress);
        GlassFish provisionedGlassFish = gfProvisioner.getGlassFish();
        GlassFishProvisionedService service = new GlassFishProvisionedService(serviceDescription, serviceProperties, ServiceStatus.RUNNING, provisionedGlassFish);
        String clusterName = serviceDescription.getVirtualClusterName();
        for (int currentClusterSize = this.domain.getClusterNamed(clusterName).getInstances().size(); currentClusterSize > 0; --currentClusterSize) {
            ServiceDescription sd = new ServiceDescription(serviceDescription);
            sd.setName(serviceName + "." + currentClusterSize);
            ProvisionedService provisionedService = super.startService(sd);
            service.addChildService(provisionedService);
        }
        this.commandRunner.run("start-cluster", new String[]{serviceDescription.getVirtualClusterName()});
        this.commandRunner.run("enable-auto-scaling", new String[]{serviceName});
        return service;
    }

    public boolean stopService(ProvisionedService provisionedService, ServiceInfo serviceInfo) {
        ServiceDescription serviceDescription = provisionedService.getServiceDescription();
        String serviceName = serviceDescription.getName();
        this.commandRunner.run("disable-auto-scaling", new String[]{serviceName});
        boolean stopSuccessful = false;
        String clusterName = serviceDescription.getVirtualClusterName();
        for (int currentClusterSize = this.domain.getClusterNamed(clusterName).getInstances().size(); currentClusterSize > 0; --currentClusterSize) {
            ServiceDescription sd = new ServiceDescription(serviceDescription);
            sd.setName(serviceName + "." + currentClusterSize);
            stopSuccessful = super.stopService(sd) || stopSuccessful;
            for (org.glassfish.paas.orchestrator.service.spi.Service childService : provisionedService.getChildServices()) {
                ProvisionedService ps = (ProvisionedService)childService;
                if (!sd.getName().equals(ps.getName()) || !stopSuccessful) continue;
                ps.setStatus(ServiceStatus.STOPPED);
            }
        }
        this.commandRunner.run("stop-cluster", new String[]{serviceDescription.getVirtualClusterName()});
        provisionedService.setStatus(ServiceStatus.STOPPED);
        return stopSuccessful;
    }

    public ProvisionedService getProvisionedService(ServiceDescription serviceDescription, ServiceInfo serviceInfo) {
        String dasIPAddress = this.gfServiceUtil.getDASIPAddress(serviceDescription.getName());
        Properties serviceProperties = new Properties();
        serviceProperties.setProperty("host", dasIPAddress);
        GlassFishProvisioner gfProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(dasIPAddress);
        GlassFish provisionedGlassFish = gfProvisioner.getGlassFish();
        GlassFishProvisionedService gfps = new GlassFishProvisionedService(serviceDescription, serviceProperties, ServiceStatus.RUNNING, provisionedGlassFish);
        if (serviceInfo.getChildServices() != null) {
            for (ServiceInfo childService : serviceInfo.getChildServices()) {
                ServiceDescription childSD = new ServiceDescription(serviceDescription);
                childSD.setName(childService.getServiceName());
                Properties childServiceProperties = new Properties();
                childServiceProperties.putAll((Map<?, ?>)serviceInfo.getProperties());
                GlassFishProvisionedService childPS = new GlassFishProvisionedService(childSD, childServiceProperties, ServiceStatus.RUNNING, null);
                gfps.addChildService((ProvisionedService)childPS);
            }
        }
        return gfps;
    }

    public void associateServices(org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, ServiceReference svcRef, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider, boolean beforeDeployment, PaaSDeploymentContext dc) {
        if ("javax.sql.DataSource".equals(svcRef.getType()) && serviceProvider.getServiceType().toString().equals("Database") && serviceConsumer.getServiceType().toString().equals("JavaEE")) {
            String serviceName;
            if (!beforeDeployment) {
                return;
            }
            Properties databaseServiceProperties = new Properties();
            if (svcRef.getProperties() != null) {
                databaseServiceProperties.putAll((Map<?, ?>)svcRef.getProperties());
            }
            if (serviceProvider.getServiceProperties() != null) {
                databaseServiceProperties.putAll((Map<?, ?>)serviceProvider.getServiceProperties());
                String serverName = serviceProvider.getServiceProperties().getProperty("host");
                String url = serviceProvider.getServiceProperties().getProperty("URL");
                if (serverName != null) {
                    databaseServiceProperties.setProperty("serverName", serverName);
                }
                if (url != null) {
                    databaseServiceProperties.setProperty("URL", url);
                }
            }
            String clusterName = serviceName = serviceConsumer.getServiceDescription().getName();
            String dasIPAddress = this.gfServiceUtil.getDASIPAddress(serviceConsumer.getServiceDescription().getName());
            String poolName = svcRef.getName();
            String resourceName = svcRef.getName();
            if (!this.processResourcesXML(dc, resourceName, databaseServiceProperties)) {
                GlassFishProvisioner glassFishProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(dasIPAddress);
                glassFishProvisioner.createJdbcConnectionPool(dasIPAddress, clusterName, databaseServiceProperties, poolName);
                glassFishProvisioner.createJdbcResource(dasIPAddress, clusterName, poolName, resourceName);
            }
        }
    }

    private boolean processResourcesXML(PaaSDeploymentContext dc, String resourceName, Properties databaseServiceProperties) {
        if (dc != null && dc.getDeploymentContext() != null) {
            Map resourceXmlParsers = (Map)dc.getTransientAppMetaData("resourceXmlParsers", Map.class);
            List nonConnectorResources = (List)dc.getTransientAppMetaData("nonConnectorResources", List.class);
            ResourcesXMLParser parser = null;
            boolean isDeploymentPlanComplete = true;
            Resource processedResource = null;
            for (Resource res : nonConnectorResources) {
                Resource connPool;
                if (!res.getType().equals("jdbc-resource")) continue;
                if (res.getAttributes().get("jndi-name").equals(resourceName)) {
                    connPool = this.archiveProcessor.getConnectionPool(res, resourceXmlParsers);
                    parser = (ResourcesXMLParser)resourceXmlParsers.get(connPool);
                    databaseServiceProperties.remove("host");
                    Resource modifiedConnPool = new Resource(connPool.getType());
                    modifiedConnPool.setDescription(connPool.getDescription());
                    modifiedConnPool.getAttributes().putAll(connPool.getAttributes());
                    modifiedConnPool.getAttributes().put("datasource-classname", databaseServiceProperties.remove("classname"));
                    modifiedConnPool.getAttributes().put("res-type", databaseServiceProperties.remove("resourcetype"));
                    modifiedConnPool.getProperties().putAll((Map<?, ?>)connPool.getProperties());
                    modifiedConnPool.getProperties().putAll((Map<?, ?>)databaseServiceProperties);
                    modifiedConnPool.getProperties().remove("service-name");
                    parser.updateDocumentNode(connPool, modifiedConnPool);
                    processedResource = res;
                    continue;
                }
                connPool = this.archiveProcessor.getConnectionPool(res, resourceXmlParsers);
                if (connPool.getProperties().getProperty("service-name") == null) continue;
                isDeploymentPlanComplete = false;
            }
            if (processedResource != null) {
                resourceXmlParsers.remove(processedResource);
                nonConnectorResources.remove(processedResource);
                if (isDeploymentPlanComplete) {
                    try {
                        File dir = File.createTempFile(DEPLOYMENT_PLAN_DIR, null);
                        dir.delete();
                        dir.mkdirs();
                        dir.deleteOnExit();
                        String xmlName = parser.getResourceFile().getName();
                        parser.persist(new File(dir, xmlName));
                        ZipWriter zipWriter = new ZipWriter(dir + ".jar", dir.getAbsolutePath());
                        zipWriter.write();
                        DeployCommandParameters dcp = (DeployCommandParameters)dc.getDeploymentContext().getCommandParameters(DeployCommandParameters.class);
                        dcp.deploymentplan = new File(dir + ".jar");
                        dcp.deploymentplan.deleteOnExit();
                        this.handleDeploymentPlan(dc.getDeploymentContext());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void handleDeploymentPlan(DeploymentContext dc) throws IOException {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        File deploymentPlan = params.deploymentplan;
        ClassLoader cl = dc.getClassLoader();
        ReadableArchive sourceArchive = dc.getSource();
        String archieType = (String)dc.getTransientAppMetaData("archive-type", String.class);
        Archivist archivist = this.archivistFactory.getArchivist(archieType, cl);
        ApplicationHolder holder = (ApplicationHolder)dc.getModuleMetaData(ApplicationHolder.class);
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.setParentArchive(sourceArchive);
            dpa.open(deploymentPlan.toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            if (archivist instanceof ApplicationArchivist) {
                ((ApplicationArchivist)archivist).copyInto(holder.app, (ReadableArchive)dpa, targetArchive, false);
            } else {
                archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
            }
        }
    }

    public void dissociateServices(org.glassfish.paas.orchestrator.service.spi.Service serviceConsumer, ServiceReference svcRef, org.glassfish.paas.orchestrator.service.spi.Service serviceProvider, boolean beforeUndeploy, PaaSDeploymentContext dc) {
        if (!beforeUndeploy && svcRef.getType().equals("javax.sql.DataSource") && serviceProvider.getServiceType().toString().equals("Database") && serviceConsumer.getServiceType().toString().equals("JavaEE")) {
            String serviceName;
            GlassFishProvisionedService glassfishProvisionedService = (GlassFishProvisionedService)serviceConsumer;
            String clusterName = serviceName = glassfishProvisionedService.getServiceDescription().getName();
            String poolName = svcRef.getName();
            String resourceName = svcRef.getName();
            String dasIPAddress = this.gfServiceUtil.getDASIPAddress(glassfishProvisionedService.getServiceDescription().getName());
            GlassFishProvisioner glassFishProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(dasIPAddress);
            glassFishProvisioner.deleteJdbcResource(dasIPAddress, clusterName, resourceName);
            glassFishProvisioner.deleteJdbcConnectionPool(dasIPAddress, poolName);
        }
    }

    public boolean undeploy(PaaSDeploymentContext dc, org.glassfish.paas.orchestrator.service.spi.Service service) {
        ReadableArchive cloudArchive = dc.getArchive();
        if (service instanceof GlassFishProvisionedService) {
            GlassFishProvisionedService gfps = (GlassFishProvisionedService)service;
            try {
                logger.info("Undeploying " + cloudArchive.getName() + " using GlassFish plugin");
                gfps.getProvisionedGlassFish().getCommandRunner().run("undeploy", new String[]{"--target=" + gfps.getServiceDescription().getVirtualClusterName(), cloudArchive.getName()});
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.warning("Unable to undeploy " + cloudArchive.getName() + " using GlassFish plugin. " + "The service is not an instance of GlassFishProvisionedService");
        }
        return true;
    }

    public boolean deploy(PaaSDeploymentContext dc, org.glassfish.paas.orchestrator.service.spi.Service service) {
        ReadableArchive cloudArchive = dc.getArchive();
        if (service instanceof GlassFishProvisionedService) {
            GlassFishProvisionedService gfps = (GlassFishProvisionedService)service;
            try {
                File archive = new File(cloudArchive.getURI());
                logger.info("Deploying " + archive + " using GlassFish plugin");
                VirtualMachine vm = gfps.getVM();
                vm.upload(archive, new File("/tmp"));
                gfps.getProvisionedGlassFish().getCommandRunner().run("deploy", new String[]{"--target=" + gfps.getServiceDescription().getVirtualClusterName(), "/tmp/" + archive.getName()});
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.warning("Unable to deploy " + cloudArchive + " using GlassFish plugin. " + "The service is not an instance of GlassFishProvisionedService");
            return false;
        }
        return true;
    }

    public boolean isRunning(ProvisionedService provisionedSvc) {
        return provisionedSvc.getStatus().equals((Object)ServiceStatus.RUNNING);
    }

    public ProvisionedService match(ServiceReference svcRef) {
        return null;
    }

    public Set<ServiceDescription> getImplicitServiceDescriptions(ReadableArchive readableArchive, String appName, PaaSDeploymentContext context) {
        HashSet<ServiceDescription> defs = new HashSet<ServiceDescription>();
        if (JavaEEDeploymentUtils.isJavaEE((ReadableArchive)readableArchive, (Habitat)this.habitat)) {
            ServiceDescription sd = this.generateDefaultServiceDescription(appName);
            defs.add(sd);
        }
        return defs;
    }

    private ServiceDescription generateDefaultServiceDescription(String appName) {
        ArrayList<Property> characteristics = new ArrayList<Property>();
        characteristics.add(new Property("service-type", "JavaEE"));
        ArrayList<Property> configurations = new ArrayList<Property>();
        configurations.add(new Property("min.clustersize", "2"));
        configurations.add(new Property("max.clustersize", "4"));
        return new ServiceDescription("gf-service-" + appName, appName, "lazy", (Object)new ServiceCharacteristics(characteristics), configurations);
    }

    public ProvisionedService scaleService(ProvisionedService provisionedService, int scaleCount, AllocationStrategy allocStrategy) {
        if (scaleCount > 0) {
            this.scaleUpService(provisionedService, scaleCount, allocStrategy);
        } else {
            this.scaleDownService(provisionedService, -scaleCount);
        }
        return provisionedService;
    }

    private void scaleUpService(ProvisionedService provisionedService, int scaleCount, AllocationStrategy allocStrategy) {
        int maxClusterSize;
        ServiceDescription serviceDescription = provisionedService.getServiceDescription();
        String serviceName = serviceDescription.getName();
        String clusterName = serviceDescription.getVirtualClusterName();
        int currentClusterSize = this.domain.getClusterNamed(clusterName).getInstances().size();
        if (currentClusterSize + scaleCount > (maxClusterSize = Integer.parseInt(serviceDescription.getConfiguration("max.clustersize")))) {
            String errMsg = "\nUnable to scale the service beyond the maximum size [" + maxClusterSize + "], " + "current size is [" + currentClusterSize + "]";
            throw new ServiceProvisioningException(errMsg);
        }
        ArrayList<ProvisioningFuture> futures = new ArrayList<ProvisioningFuture>();
        int i = currentClusterSize + 1;
        while (scaleCount > 0) {
            ServiceDescription sd = new ServiceDescription(serviceDescription);
            sd.setName(serviceName + "." + (i + 1));
            futures.add(this.createService(sd, allocStrategy, null));
            --scaleCount;
            ++i;
        }
        for (ProvisioningFuture future : futures) {
            ProvisionedService ps = future.get();
            provisionedService.getChildServices().add(ps);
        }
    }

    private void scaleDownService(ProvisionedService provisionedService, int scaleCount) throws ServiceProvisioningException {
        int minClusterSize;
        ServiceDescription serviceDescription = provisionedService.getServiceDescription();
        String serviceName = serviceDescription.getName();
        String clusterName = serviceDescription.getVirtualClusterName();
        int currentClusterSize = this.domain.getClusterNamed(clusterName).getInstances().size();
        if (currentClusterSize - scaleCount < (minClusterSize = Integer.parseInt(serviceDescription.getConfiguration("min.clustersize")))) {
            String errMsg = "\nUnable to scale the service below the minimum required size [" + minClusterSize + "], " + "current size is [" + currentClusterSize + "]";
            throw new ServiceProvisioningException(errMsg);
        }
        int i = currentClusterSize;
        while (scaleCount > 0) {
            ServiceDescription sd = new ServiceDescription(serviceDescription);
            sd.setName(serviceName + "." + (i + 1));
            boolean deleteSuccessful = super.deleteService(sd);
            if (deleteSuccessful) {
                org.glassfish.paas.orchestrator.service.spi.Service serviceToPurge = null;
                for (org.glassfish.paas.orchestrator.service.spi.Service service : provisionedService.getChildServices()) {
                    if (!service.getName().equals(sd.getName())) continue;
                    serviceToPurge = service;
                    break;
                }
                if (serviceToPurge != null) {
                    provisionedService.getChildServices().remove(serviceToPurge);
                }
            }
            --scaleCount;
            --i;
        }
    }

    public boolean reconfigureServices(ProvisionedService oldPS, ProvisionedService newPS) {
        throw new UnsupportedOperationException("Reconfiguration of Service not supported in this release");
    }

    public boolean reassociateServices(org.glassfish.paas.orchestrator.service.spi.Service svcConsumer, org.glassfish.paas.orchestrator.service.spi.Service oldSvcProvider, org.glassfish.paas.orchestrator.service.spi.Service newSvcProvider, ServiceOrchestrator.ReconfigAction reason) {
        throw new UnsupportedOperationException("Reassociation of Service not supported in this release");
    }
}

