/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.paas.gfplugin.ClientRuntimeWrapper;
import org.glassfish.paas.gfplugin.cli.ApplicationServerProvisioner;
import org.glassfish.paas.orchestrator.provisioning.util.RemoteCommandExecutor;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GlassFishProvisioner
implements ApplicationServerProvisioner {
    @Inject
    private RemoteCommandExecutor remoteCommandExecutor;
    private GlassFish glassFish;
    private CommandRunner commandRunner;
    private Deployer deployer;
    public static final String CLUSTER = "gf-cluster";
    public static final String NODE_PREFIX = "node-";
    public static final String INSTANCE_PREFIX = "instance-";
    private String userName;
    private String host;
    private String port;
    private String target;
    private String glassFishInstallDir;
    public static final String GF_PORT = "GF_PORT";
    public static final String GF_TARGET = "GF_TARGET";
    public static final String GF_HOST = "GF_HOST";
    public static final String AWS_KEYPAIR = "AWS_KEYPAIR";
    public static final String AWS_INSTANCE_USERNAME = "AWS_INSTANCE_USERNAME";
    public static final String AWS_LOCAL_KEYPAIR_LOCATION = "AWS_LOCAL_KEYPAIR_LOCATION";
    public static final String APPLICATION_SERVER_PROVIDER = "APPLICATION_SERVER_PROVIDER";
    public static final String GLASSFISH = "GLASSFISH";
    public static final String GF_INSTALL_DIR = "GF_INSTALL_DIR";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DATABASENAME = "databasename";
    public static final String PORTNUMBER = "portnumber";
    public static final String URL = "url";
    public static final String RESOURCE_TYPE = "resourcetype";
    public static final String CLASSNAME = "classname";
    private String instanceUserName;
    private String keyPair;
    private String awsLocalKeyPairLocation;
    private Properties properties;

    public CommandRunner getCommandRunner() {
        if (this.commandRunner != null) {
            return this.commandRunner;
        }
        try {
            this.commandRunner = this.getGlassFish().getCommandRunner();
        }
        catch (GlassFishException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this.commandRunner;
    }

    public Deployer getDeployer() {
        if (this.deployer != null) {
            return this.deployer;
        }
        try {
            this.deployer = this.getGlassFish().getDeployer();
        }
        catch (GlassFishException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this.deployer;
    }

    public GlassFish getGlassFish() {
        if (this.glassFish == null) {
            BootstrapProperties bootstrapProperties = new BootstrapProperties();
            bootstrapProperties.setProperty("GlassFish_Platform", "GlassFishClient");
            try {
                GlassFishRuntime glassFishRuntime = ClientRuntimeWrapper.bootstrap(bootstrapProperties);
                System.out.println("GlassFishRuntime = [" + glassFishRuntime + "]");
                GlassFishProperties gfProperties = new GlassFishProperties();
                gfProperties.setProperty("host", this.host);
                gfProperties.setProperty("port", this.port);
                gfProperties.getProperties().putAll((Map<?, ?>)this.properties);
                this.glassFish = glassFishRuntime.newGlassFish(gfProperties);
                System.out.println("GlassFish = [" + this.glassFish + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.glassFish;
    }

    @Override
    public void initialize(Properties properties) {
        this.properties = properties;
        this.userName = (String)properties.get(AWS_INSTANCE_USERNAME);
        this.port = (String)properties.get(GF_PORT);
        this.target = (String)properties.get(GF_TARGET);
        this.host = (String)properties.get(GF_HOST);
        this.instanceUserName = (String)properties.get(AWS_INSTANCE_USERNAME);
        this.keyPair = (String)properties.get(AWS_KEYPAIR);
        this.glassFishInstallDir = (String)properties.get(GF_INSTALL_DIR);
        this.awsLocalKeyPairLocation = (String)properties.get(AWS_LOCAL_KEYPAIR_LOCATION);
    }

    @Override
    public void provisionCluster(int instancesCount, List<String> instanceIPs, String masterInstanceIP) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void unProvisionCluster(int instancesCount, List<String> remoteInstanceIPs, String masterInstanceIP) {
        throw new RuntimeException("not supported");
    }

    @Override
    public int scaleUp(int count, String clusterName) {
        return -1;
    }

    @Override
    public int scaleDown(int count, String clusterName) {
        return -1;
    }

    @Override
    public String provisionNode(String dasIP, String instanceIP, String clusterName, String nodeName, String instanceName) {
        this.setupSSH(dasIP, instanceIP);
        this.createNodeSSH(dasIP, instanceIP, nodeName);
        this.createInstance(dasIP, clusterName, nodeName, instanceName);
        return instanceName;
    }

    @Override
    public void unProvisionNode(String dasIP, String instanceIP, String nodeName, String instanceName) {
        this.stopInstance(dasIP, instanceName);
        this.deleteInstance(dasIP, instanceName);
        this.deleteNodeSSH(dasIP, instanceIP, nodeName, true);
    }

    @Override
    public void stopCluster(String masterInstanceIP, String cluster) {
        String[] args = new String[]{cluster};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("stop-cluster", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public void deleteJdbcConnectionPool(String masterInstanceIP, String poolName) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(poolName);
        String[] parameters = new String[params.size()];
        parameters = params.toArray(parameters);
        CommandResult commandResult = this.getCommandRunner().run("delete-jdbc-connection-pool", parameters);
        this.logCommandResult(commandResult);
    }

    @Override
    public void deleteJdbcResource(String masterInstanceIP, String target, String resourceName) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("--target=" + target);
        params.add(resourceName);
        String[] parameters = new String[params.size()];
        parameters = params.toArray(parameters);
        CommandResult commandResult = this.getCommandRunner().run("delete-jdbc-resource", parameters);
        this.logCommandResult(commandResult);
    }

    @Override
    public void createJdbcConnectionPool(String masterInstanceIP, String target, Properties props, String poolName) {
        ArrayList<String> params = new ArrayList<String>();
        Properties properties = (Properties)props.clone();
        if (properties.get(RESOURCE_TYPE) != null) {
            params.add("--resType=" + (String)properties.get(RESOURCE_TYPE));
            properties.remove(RESOURCE_TYPE);
        }
        if (properties.get(CLASSNAME) == null) {
            throw new RuntimeException("classname is mandatory for creating jdbc-connection-pool");
        }
        params.add("--datasourceClassname=" + (String)properties.get(CLASSNAME));
        properties.remove(CLASSNAME);
        StringBuffer poolPropertiesArgument = this.generatePoolProperties(properties);
        if (poolPropertiesArgument != null && poolPropertiesArgument.length() > 0) {
            params.add("--property=" + poolPropertiesArgument.toString());
        }
        if (target != null) {
            params.add("--target=" + target);
        }
        params.add(poolName);
        Object[] parameters = new String[params.size()];
        parameters = params.toArray(parameters);
        System.out.println("create-jdbc-connection-pool command params : " + Arrays.toString(parameters));
        CommandResult commandResult = this.getCommandRunner().run("create-jdbc-connection-pool", (String[])parameters);
        this.logCommandResult(commandResult);
    }

    @Override
    public void createJdbcResource(String masterInstanceIP, String target, String poolName, String resourceName) {
        ArrayList<String> params = new ArrayList<String>();
        if (poolName == null) {
            throw new RuntimeException("pool-name cannot be null for create-jdbc-resource");
        }
        if (resourceName == null) {
            throw new RuntimeException("resource-name cannot be null for create-jdbc-resource");
        }
        if (target != null) {
            params.add("--target");
            params.add(target);
        }
        params.add("--connectionpoolid");
        params.add(poolName);
        params.add(resourceName);
        Object[] parameters = new String[params.size()];
        parameters = params.toArray(parameters);
        System.out.println("create-jdbc-resource command params : " + Arrays.toString(parameters));
        CommandResult commandResult = this.getCommandRunner().run("create-jdbc-resource", (String[])parameters);
        this.logCommandResult(commandResult);
    }

    @Override
    public void refreshLBConfiguration(String masterInstanceIP, String lbServiceName) {
        String command = "apply-http-lb-changes";
        String[] options = new String[]{lbServiceName};
        this.executeRemoteCommand(command, options);
        this.executeRemoteCommand(command, options);
    }

    @Override
    public void associateLBWithApplicationServer(String masterInstanceIP, String targetName, String lbIPAddress, String lbServiceName) {
        String deviceHost = lbIPAddress;
        String command = "create-http-lb";
        String[] options = new String[]{"--target", targetName, "--devicehost", deviceHost, "--deviceport", "50443", lbServiceName};
        this.executeRemoteCommand(command, options);
        this.refreshLBConfiguration(masterInstanceIP, lbServiceName);
    }

    private StringBuffer generatePoolProperties(Properties properties) {
        StringBuffer propertiesString = new StringBuffer();
        for (Object key : properties.keySet()) {
            if (propertiesString.length() > 0) {
                propertiesString.append(":");
            }
            propertiesString.append(key.toString() + "=" + GlassFishProvisioner.escape(properties.get(key).toString()));
        }
        return propertiesString;
    }

    private static String escape(String input) {
        return input.replace("=", "\\=").replace(":", "\\:");
    }

    @Override
    public void enableSecureAdmin(String ipAddress) {
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "enable-secure-admin";
        String[] args = new String[]{this.userName, ipAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    @Override
    public void startDomain(String ipAddress, String domainName) {
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "start-domain " + domainName;
        String[] args = new String[]{this.userName, ipAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    @Override
    public void createDomain(String domainName, String ipAddress, String ... options) {
        String params = "";
        if (options != null && options.length > 0) {
            for (String option : options) {
                params = params + option.trim() + " ";
            }
        }
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "create-domain " + params + domainName;
        String[] args = new String[]{this.userName, ipAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    @Override
    public void deleteDomain(String domainName, String ipAddress) {
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "delete-domain " + domainName;
        String[] args = new String[]{this.userName, ipAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    @Override
    public void stopDomain(String ipAddress, String domainName) {
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "stop-domain " + domainName;
        String[] args = new String[]{this.userName, ipAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    @Override
    public void deleteCluster(String masterInstanceIP, String cluster, boolean cascade) {
        String[] args = new String[]{cluster};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("delete-cluster", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public String deploy(String masterInstanceIP, String appLocation, String ... options) {
        try {
            String result = this.getDeployer().deploy(new File(appLocation), options);
            System.out.println("deployed : " + result);
            return result;
        }
        catch (GlassFishException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startCluster(String masterInstanceIP, String cluster) {
        String[] args = new String[]{cluster};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("start-cluster", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public void createInstance(String masterInstanceIP, String cluster, String node, String instance) {
        String[] args = null;
        args = cluster != null ? new String[]{"--cluster", cluster, "--checkports", "false", "--node", node, instance} : new String[]{"--checkports", "false", "--node", node, instance};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("create-instance", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public void createCluster(String masterInstanceIP, String cluster) {
        String[] args = new String[]{cluster};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("create-cluster", args);
        this.logCommandResult(commandResult);
    }

    public void createNodeSSH(String dasIp, String instanceIp, String nodeName) {
        String[] args = new String[]{"--sshuser", this.userName, "--sshkeyfile", this.keyPair, "--nodehost", instanceIp, "--installdir", this.glassFishInstallDir, nodeName};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("create-node-ssh", args);
        this.logCommandResult(commandResult);
    }

    public void deleteNodeSSH(String dasIp, String instanceIp, String nodeName, boolean cascade) {
        String[] args = new String[]{nodeName};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("delete-node-ssh", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public void deleteInstance(String dasIp, String instanceName) {
        String[] args = new String[]{instanceName};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("delete-instance", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public void stopInstance(String dasIp, String instanceName) {
        String[] args = new String[]{instanceName};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("stop-instance", args);
        this.logCommandResult(commandResult);
    }

    @Override
    public CommandResult executeRemoteCommand(String command, String ... options) {
        CommandResult commandResult = this.getCommandRunner().run(command, options);
        this.logCommandResult(commandResult);
        return commandResult;
    }

    @Override
    public boolean handles(Properties metaData) {
        String value = (String)metaData.get(APPLICATION_SERVER_PROVIDER);
        return value != null && value.equals(GLASSFISH);
    }

    @Override
    public void startInstance(String dasIp, String instanceName) {
        String[] args = new String[]{"--debug", instanceName};
        this.logCommand(args);
        CommandResult commandResult = this.getCommandRunner().run("start-instance", args);
        this.logCommandResult(commandResult);
    }

    private void logCommandResult(CommandResult commandResult) {
        System.out.println(commandResult.getOutput());
        if (commandResult.getFailureCause() != null) {
            System.out.println(commandResult.getFailureCause());
        }
    }

    public void setupSSH(String dasIPAddress, String instanceIPAddress) {
        String command = this.glassFishInstallDir + File.separator + "glassfish" + File.separator + "bin" + File.separator + "asadmin " + "setup-ssh " + " --secure=false " + "--sshuser " + this.userName + " --sshkeyfile " + this.keyPair + " " + instanceIPAddress;
        String[] args = new String[]{this.userName, dasIPAddress, this.awsLocalKeyPairLocation, command};
        this.remoteCommandExecutor.executeCommand(args);
    }

    private void logCommand(String[] args) {
    }
}

