/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin;

import com.sun.enterprise.util.OS;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.paas.gfplugin.RemoteCommandResult;
import org.glassfish.virtualization.spi.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandRunnerClient
implements CommandRunner {
    private VirtualMachine vm;
    private String adminPort;
    private static final MessageFormat ASADMIN_COMMAND = new MessageFormat("{0}" + File.separator + "lib" + File.separator + "nadmin" + (OS.isWindows() ? ".bat" : ""));

    public RemoteCommandRunnerClient(Properties glassfishProperties) {
        this.vm = (VirtualMachine)glassfishProperties.get("vm");
        this.adminPort = glassfishProperties.getProperty("port");
    }

    public CommandResult run(String command, String ... args) {
        String passfile;
        String interactiveArg;
        ArrayList<String> argsAsList = new ArrayList<String>();
        Collections.addAll(argsAsList, args);
        ArrayList<String> allArgs = new ArrayList<String>();
        String[] installDir = new String[]{this.vm.getProperty(VirtualMachine.PropertyName.INSTALL_DIR) + File.separator + "glassfish"};
        allArgs.add(ASADMIN_COMMAND.format(installDir).toString());
        allArgs.add("--host=" + this.vm.getAddress().getHostAddress());
        allArgs.add("--port=" + this.adminPort);
        String userArg = this.removeArg(argsAsList, "--user");
        if (userArg != null) {
            allArgs.add(userArg);
        }
        if ((interactiveArg = this.removeArg(argsAsList, "--interactive")) != null) {
            allArgs.add(interactiveArg);
        }
        if ((passfile = this.removeArg(argsAsList, "--passwordfile")) != null) {
            File passwdFile = new File(passfile.substring(passfile.indexOf(61) + 1));
            try {
                this.vm.executeOn(new String[]{"mkdir", "-p", "/tmp/passwd"});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.vm.upload(passwdFile, new File("/tmp/passwd"));
            allArgs.add("--passwordfile=/tmp/passwd/" + passwdFile.getName());
        }
        allArgs.add(command);
        allArgs.addAll(argsAsList);
        try {
            String output = this.vm.executeOn(allArgs.toArray(new String[0]));
            System.out.println("\nRan command :-> " + ((Object)allArgs).toString().replace(',', ' ') + "\n\noutput :-> " + output);
            if (output.indexOf("successfully") != -1) {
                return new RemoteCommandResult(0, output, null);
            }
            return new RemoteCommandResult(1, output, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RemoteCommandResult(1, e.getMessage(), e);
        }
    }

    private String removeArg(List<String> args, String argName) {
        ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
        String value = null;
        for (String arg : args) {
            if (!arg.startsWith(argName)) continue;
            int index = args.indexOf(arg);
            if (arg.indexOf("=") == -1) {
                removeIndexes.add(index);
                removeIndexes.add(index + 1);
                value = args.get(index) + "=" + args.get(index + 1);
                continue;
            }
            removeIndexes.add(index);
            value = arg.trim();
        }
        Iterator<String> i$ = removeIndexes.iterator();
        while (i$.hasNext()) {
            int index = (Integer)((Object)i$.next());
            args.remove(index);
        }
        return value;
    }

    public void setTerse(boolean terse) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

