/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.cli;

import org.glassfish.hk2.scopes.Singleton;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;

@Service
@Scoped(value=Singleton.class)
public class GlassFishServiceUtil {
    private static final String SEPARATOR = ".";
    public static final String NODE_PREFIX = "node-";
    public static final String INSTANCE_PREFIX = "instance-";

    public boolean isInstance(String serviceName) {
        boolean instance = false;
        if (this.isClusteredInstance(serviceName)) {
            instance = true;
        }
        return instance;
    }

    public String getInstanceName(String serviceName) {
        String instanceName = null;
        if (this.isInstance(serviceName)) {
            if (this.isClusteredInstance(serviceName)) {
                instanceName = this.getClusteredInstanceName(serviceName);
            }
        } else {
            throw new RuntimeException("not an instance [" + serviceName + "]");
        }
        return instanceName;
    }

    public String getClusteredInstanceName(String serviceName) {
        String instanceName = null;
        if (this.isClusteredInstance(serviceName)) {
            int lastIndex = serviceName.lastIndexOf(SEPARATOR);
            instanceName = serviceName.substring(lastIndex + 1);
        }
        return instanceName;
    }

    public boolean isClusteredInstance(String serviceName) {
        boolean isInstance = false;
        if (serviceName.contains(SEPARATOR)) {
            int count = 0;
            CharSequence sequence = serviceName.subSequence(0, serviceName.length() - 1);
            for (int i = 0; i < sequence.length(); ++i) {
                if (sequence.charAt(i) != '.') continue;
                ++count;
            }
            if (count == 1) {
                isInstance = true;
            }
        }
        return isInstance;
    }

    public String generateNodeName(String suffix) {
        return NODE_PREFIX + suffix;
    }

    public String generateInstanceName(String suffix) {
        return INSTANCE_PREFIX + suffix;
    }

    public String getDASIPAddress(String serviceName) {
        String dasIPAddress = "localhost";
        return dasIPAddress;
    }
}

