/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.paas.gfplugin.cli.ApplicationServerProvisioner;
import org.glassfish.paas.gfplugin.cli.Provisioner;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Scoped(value=Singleton.class)
@Service
public class ProvisionerUtil {
    private Properties cloudConfig = null;
    @Inject
    private Habitat habitat;
    private Map<String, ApplicationServerProvisioner> appserverProvisioners = new HashMap<String, ApplicationServerProvisioner>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        String installRoot;
        File propertiesFile;
        if (this.cloudConfig == null && (propertiesFile = new File((installRoot = System.getProperty("com.sun.aas.installRoot")) + File.separator + "config" + File.separator + "cloud-config.properties")).exists()) {
            Properties properties = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties = new Properties();
                properties.load(fis);
                this.cloudConfig = properties;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (this.cloudConfig != null) {
            return (Properties)this.cloudConfig.clone();
        }
        System.err.println("Unable to find cloud-config.properties file in 'config' directory. Returning EMPTY properties.");
        return new Properties();
    }

    public ApplicationServerProvisioner getAppServerProvisioner(Properties properties) {
        String host = properties.getProperty("ip-address");
        if (this.appserverProvisioners.containsKey(host)) {
            return this.appserverProvisioners.get(host);
        }
        properties.put("APPLICATION_SERVER_PROVIDER", "GLASSFISH");
        properties.put("GF_HOST", host);
        properties.put("GF_PORT", "24848");
        ApplicationServerProvisioner provisioner = (ApplicationServerProvisioner)this.getProvisioner(properties, ApplicationServerProvisioner.class);
        provisioner.initialize(properties);
        this.appserverProvisioners.put(host, provisioner);
        return provisioner;
    }

    public ApplicationServerProvisioner getAppServerProvisioner(String host) {
        if (this.appserverProvisioners.containsKey(host)) {
            return this.appserverProvisioners.get(host);
        }
        Properties properties = this.getProperties();
        properties.put("GF_HOST", host);
        if (!properties.containsKey("APPLICATION_SERVER_PROVIDER")) {
            properties.put("APPLICATION_SERVER_PROVIDER", "GLASSFISH");
            properties.put("GF_PORT", "24848");
        }
        ApplicationServerProvisioner provisioner = (ApplicationServerProvisioner)this.getProvisioner(properties, ApplicationServerProvisioner.class);
        provisioner.initialize(properties);
        this.appserverProvisioners.put(host, provisioner);
        return provisioner;
    }

    public Provisioner getProvisioner(Properties metaData, Class clz) {
        Collection provisioners = this.habitat.getAllByContract(clz);
        for (Provisioner provisioner : provisioners) {
            try {
                if (!provisioner.handles(metaData) || !clz.isAssignableFrom(provisioner.getClass())) continue;
                System.out.println("Found Provisioner for type [" + clz + "] : " + provisioner.getClass());
                provisioner.initialize(metaData);
                return provisioner;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Unable to get an Provisioner for metaData " + metaData);
    }
}

