/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.cli;

import com.sun.enterprise.util.io.FileUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.paas.orchestrator.provisioning.cli.ServiceUtil;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.AllocationConstraints;
import org.glassfish.virtualization.spi.IAAS;
import org.glassfish.virtualization.spi.PhasedFuture;
import org.glassfish.virtualization.spi.TemplateCondition;
import org.glassfish.virtualization.spi.TemplateInstance;
import org.glassfish.virtualization.spi.TemplateRepository;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.ServiceType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="regenerate-glassfish-template")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class RegenerateGlassFishTemplate
implements AdminCommand,
Runnable {
    @Param(name="networkinterface", optional=false)
    private String networkInterface;
    @Param(name="targetdir", optional=false)
    private String targetdir;
    @Param(name="glassfishlocation", optional=false)
    private String gflocation;
    @Param(name="waitforcompletion", optional=true, defaultValue="true")
    private boolean waitforcompletion;
    @Param(name="servicename", primary=true)
    private String serviceName;
    @Param(name="virtualcluster", optional=true)
    private String virtualClusterName;
    @Param(name="templateid", optional=true)
    private String templateId;
    @Param(name="servicecharacteristics", optional=true, separator=58)
    public Properties serviceCharacteristics;
    public Properties serviceConfigurations;
    private String clusterName;
    private String instanceName;
    private static final Logger logger = Logger.getLogger(RegenerateGlassFishTemplate.class.getName());
    @Inject(optional=true)
    private TemplateRepository templateRepository;
    @Inject(optional=true)
    IAAS iaas;
    @Inject(optional=true)
    VirtualClusters virtualClusters;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        System.out.println("regenerate-glassfish-template called.");
        this.clusterName = this.serviceName.indexOf(".") > -1 ? this.serviceName.substring(0, this.serviceName.indexOf(".")) : this.serviceName;
        String dasIPAddress = "Obtaining";
        if (this.waitforcompletion) {
            this.run();
        } else {
            ServiceUtil.getThreadPool().execute(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        TemplateInstance matchingTemplate;
        block15: {
            block16: {
                matchingTemplate = null;
                if (this.templateRepository == null) break block15;
                if (this.templateId != null) break block16;
                if (this.serviceCharacteristics == null) break block15;
                HashSet<ServiceType> andConditions = new HashSet<ServiceType>();
                andConditions.add(new ServiceType(this.serviceCharacteristics.getProperty("service-type")));
                for (TemplateInstance ti : this.templateRepository.all()) {
                    boolean allConditionsSatisfied = true;
                    for (TemplateCondition templateCondition : andConditions) {
                        if (ti.satisfies(templateCondition)) continue;
                        allConditionsSatisfied = false;
                        break;
                    }
                    if (!allConditionsSatisfied) continue;
                    matchingTemplate = ti;
                    break;
                }
                if (matchingTemplate != null) {
                    this.templateId = matchingTemplate.getConfig().getName();
                }
                break block15;
            }
            for (TemplateInstance ti : this.templateRepository.all()) {
                if (!ti.getConfig().getName().equals(this.templateId)) continue;
                matchingTemplate = ti;
                break;
            }
        }
        if (matchingTemplate != null) {
            try {
                VirtualCluster vCluster = this.virtualClusters.byName(this.virtualClusterName);
                int min = 1;
                ArrayList<PhasedFuture> futures = new ArrayList<PhasedFuture>();
                for (int i = 0; i < min; ++i) {
                    PhasedFuture future = this.iaas.allocate(new AllocationConstraints(matchingTemplate, vCluster), null);
                    futures.add(future);
                }
                NetworkInterface ni = NetworkInterface.getByName(this.networkInterface);
                Enumeration<InetAddress> e = ni.getInetAddresses();
                String string = "";
                while (e.hasMoreElements()) {
                    String string2 = e.nextElement().toString();
                }
                for (PhasedFuture future : futures) {
                    VirtualMachine vm = (VirtualMachine)future.get();
                    String commandOutput = vm.executeOn(new String[]{"echo \"cloud\" > /home/cloud/p "});
                    logger.log(Level.INFO, "Output of command echo" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"rm /home/cloud/glassfish.zip*"});
                    logger.log(Level.INFO, "Output of command rm" + commandOutput);
                    if (this.gflocation.contains("http")) {
                        commandOutput = vm.executeOn(new String[]{"wget " + this.gflocation});
                        logger.log(Level.INFO, "Output of command wget" + commandOutput);
                    } else {
                        void var7_15;
                        FileUtils.copy((String)this.gflocation, (String)(System.getenv("S1AS_HOME") + "/domains/domain1/docroot/glassfish.zip"));
                        commandOutput = vm.executeOn(new String[]{"wget http:/" + (String)var7_15 + ":8080/glassfish.zip"});
                        logger.log(Level.INFO, "Output of command wget" + commandOutput);
                    }
                    commandOutput = vm.executeOn(new String[]{"/opt/glassfishvm/glassfish3/glassfish/bin/asadmin", "stop-local-instance"});
                    logger.log(Level.INFO, "Output of command stop instance" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"rm -rf /opt/glassfishvm/glassfish3"});
                    logger.log(Level.INFO, "Output of command rm to remove prev installation" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"unzip -d /opt/glassfishvm/ glassfish.zip"});
                    logger.log(Level.INFO, "Output of command unzip latest glassfish" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"sudo -S rm /etc/opt/glassfishvm/configured_ip < /home/cloud/p"});
                    logger.log(Level.INFO, "Output of command rm configured ip file" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"sudo -S umount /etc/opt/glassfishvm/cust < /home/cloud/p"});
                    logger.log(Level.INFO, "Output of command unmount cust folder" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"sudo -S rm -rf /etc/opt/glassfishvm/cust < /home/cloud/p"});
                    logger.log(Level.INFO, "Output of command rm cust folder" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"rm", "/home/cloud/p"});
                    logger.log(Level.INFO, "Output of command rm /home/cloud/p" + commandOutput);
                    commandOutput = vm.executeOn(new String[]{"rm", "/home/cloud/glassfish.zip"});
                    logger.log(Level.INFO, "Output of command rm /home/cloud/glassfish.zip" + commandOutput);
                    vm.stop();
                    FileUtils.copy((String)(System.getenv("HOME") + "/virt/disks/glassfish1.img"), (String)(this.targetdir + "/glassfish.img"));
                    vm.delete();
                }
                return;
            }
            catch (IOException ex) {
                Logger.getLogger(RegenerateGlassFishTemplate.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(RegenerateGlassFishTemplate.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(RegenerateGlassFishTemplate.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (VirtException ex) {
                Logger.getLogger(RegenerateGlassFishTemplate.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

