/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.gfplugin.GlassFishProvisioner;
import org.glassfish.paas.gfplugin.cli.ProvisionerUtil;
import org.glassfish.paas.orchestrator.service.ServiceStatus;
import org.glassfish.paas.orchestrator.service.metadata.ServiceDescription;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.paas.spe.common.BasicProvisionedService;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;

@Service
@Scoped(value=Singleton.class)
public class DASProvisioner
implements GlassFishPluginConstants {
    @Inject
    private ProvisionerUtil provisionerUtil;

    public GlassFishProvisionedService provision(ProvisionedService serviceNode) {
        String serviceName = serviceNode.getName();
        String clusterName = serviceNode.getServiceDescription().getVirtualClusterName();
        VirtualMachine vm = ((BasicProvisionedService)serviceNode).getVM();
        ServiceDescription serviceDescription = serviceNode.getServiceDescription();
        Properties serviceProperties = new Properties();
        serviceProperties.putAll((Map<?, ?>)serviceNode.getProperties());
        serviceProperties.setProperty("min.clustersize", serviceDescription.getConfiguration("min.clustersize"));
        serviceProperties.setProperty("max.clustersize", serviceDescription.getConfiguration("max.clustersize"));
        Properties glassfishProperties = new Properties();
        glassfishProperties.putAll((Map<?, ?>)serviceNode.getProperties());
        glassfishProperties.put("vm", vm);
        GlassFishProvisioner gfProvisioner = (GlassFishProvisioner)this.provisionerUtil.getAppServerProvisioner(glassfishProperties);
        GlassFish das = gfProvisioner.getGlassFish();
        String domain = "paas-domain";
        CommandRunner cr = null;
        try {
            cr = das.getCommandRunner();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String passwordFile = this.createPasswordFile();
        cr.run("create-domain", new String[]{"--user=admin", "--adminport=24848", "--passwordfile=" + passwordFile, domain});
        cr.run("start-domain", new String[]{domain});
        cr.run("set", new String[]{"configs.config.server-config.network-config.network-listeners.network-listener.admin-listener.address=" + vm.getAddress().getHostAddress()});
        cr.run("create-cluster", new String[]{clusterName});
        cr.run("_create-elastic-service", new String[]{"--min=" + serviceDescription.getConfiguration("min.clustersize"), "--max=" + serviceDescription.getConfiguration("max.clustersize"), serviceName});
        return new GlassFishProvisionedService(serviceDescription, serviceProperties, ServiceStatus.RUNNING, das);
    }

    private String createPasswordFile() {
        OutputStreamWriter fw = null;
        try {
            File passFile = File.createTempFile("asadmin", "passwd");
            passFile.deleteOnExit();
            fw = new FileWriter(passFile);
            fw.write("AS_ADMIN_PASSWORD=\n");
            fw.flush();
            fw.close();
            String string = passFile.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

