/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import org.glassfish.api.ActionReport;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.glassfish.hk2.Services;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.TemplateCustomizer;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="JavaEE")
public class GlassFishTemplateCustomizer
implements TemplateCustomizer,
GlassFishPluginConstants {
    @Inject
    Domain domain;
    @Inject
    Services services;
    @Inject
    RuntimeContext rtContext;
    @Inject
    GMSAdapterService gmsAdapterService;

    public void customize(VirtualCluster cluster, VirtualMachine virtualMachine) throws VirtException {
        if (provisionDAS) {
            return;
        }
        ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
        String nodeName = this.getNodeName(virtualMachine);
        String installDir = virtualMachine.getProperty(VirtualMachine.PropertyName.INSTALL_DIR);
        this.rtContext.executeAdminCommand(report, "create-node-ssh", nodeName, new String[]{"nodehost", virtualMachine.getAddress().getHostAddress(), "sshUser", virtualMachine.getUser().getName(), "installdir", installDir});
        if (report.hasFailures()) {
            return;
        }
        this.rtContext.executeAdminCommand(report, "create-instance", this.getInstanceName(virtualMachine), new String[]{"node", nodeName, "cluster", cluster.getConfig().getName()});
    }

    public boolean isActive(VirtualCluster virtualCluster, VirtualMachine virtualMachine) throws VirtException {
        if (virtualMachine.getInfo().getState().equals((Object)Machine.State.READY)) {
            GMSAdapter adapter = this.gmsAdapterService.getGMSAdapterByName(virtualCluster.getConfig().getName());
            String instanceName = this.getInstanceName(virtualMachine);
            HealthHistory.InstanceHealth instanceHealth = adapter.getHealthHistory().getHealthByInstance(instanceName);
            return instanceHealth.state.equals((Object)HealthHistory.STATE.RUNNING);
        }
        return false;
    }

    public void start(VirtualMachine virtualMachine, boolean firstStart) {
        if (provisionDAS) {
            return;
        }
        String instanceName = this.getInstanceName(virtualMachine);
        Server instance = this.domain.getServerNamed(instanceName);
        if (instance != null) {
            ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
            this.rtContext.executeAdminCommand(report, "start-instance", instanceName, new String[0]);
        }
    }

    public void clean(VirtualMachine virtualMachine) {
        if (provisionDAS) {
            return;
        }
        String instanceName = this.getInstanceName(virtualMachine);
        Server server = this.domain.getServerNamed(instanceName);
        if (server != null) {
            String nodeName = server.getNodeRef();
            ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
            this.rtContext.executeAdminCommand(report, "delete-instance", instanceName, new String[0]);
            Node node = this.domain.getNodeNamed(nodeName);
            if (node != null && node.getType().equals("SSH")) {
                this.rtContext.executeAdminCommand(report, "delete-node-ssh", nodeName, new String[0]);
            }
        }
    }

    private String getNodeName(VirtualMachine virtualMachine) {
        String machineName = virtualMachine.getMachine() != null ? virtualMachine.getMachine().getName() : virtualMachine.getServerPool().getConfig().getVirtualization().getName();
        String[] args = new String[]{virtualMachine.getServerPool().getName(), machineName, virtualMachine.getName()};
        return NODE_NAME_FORMAT.format(args).toString();
    }

    private String getInstanceName(VirtualMachine virtualMachine) {
        String machineName = virtualMachine.getMachine() != null ? virtualMachine.getMachine().getName() : virtualMachine.getServerPool().getConfig().getVirtualization().getName();
        String[] args = new String[]{virtualMachine.getServerPool().getName(), machineName, virtualMachine.getName()};
        return INSTANCE_NAME_FORMAT.format(args).toString();
    }

    public void stop(VirtualMachine virtualMachine) {
        if (provisionDAS) {
            return;
        }
        String instanceName = this.getInstanceName(virtualMachine);
        Server instance = this.domain.getServerNamed(instanceName);
        if (instance != null) {
            ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
            this.rtContext.executeAdminCommand(report, "stop-instance", instanceName, new String[]{"_vmShutdown", "false"});
        }
    }
}

