/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.paas.gfplugin.GlassFishProvisionedService;
import org.glassfish.paas.gfplugin.customizer.LocalInstanceProvisioner;
import org.glassfish.paas.gfplugin.customizer.RemoteInstanceProvisioner;
import org.glassfish.paas.orchestrator.service.spi.ProvisionedService;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;

@Service
@Scoped(value=Singleton.class)
public class InstanceProvisioner
implements GlassFishPluginConstants {
    @Inject
    private LocalInstanceProvisioner localInstanceProvisioner;
    @Inject
    private RemoteInstanceProvisioner remoteInstanceProvisioner;
    @Inject(optional=true)
    private VirtualClusters virtualClusters;

    public void provision(GlassFishProvisionedService das, ProvisionedService ... instances) {
        String clusterName = das.getServiceDescription().getVirtualClusterName();
        VirtualCluster virtualCluster = null;
        try {
            virtualCluster = this.virtualClusters.byName(clusterName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String vmId = das.getServiceProperties().getProperty("vm-id");
        VirtualMachine dasVM = virtualCluster.vmByName(vmId);
        String virtType = dasVM.getConfig().getTemplate().byName("VirtualizationType").getValue();
        if ("Native".equalsIgnoreCase(virtType)) {
            this.localInstanceProvisioner.provision(das, instances);
        } else {
            this.remoteInstanceProvisioner.provision(das, instances);
        }
    }
}

