/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.paas.gfplugin.customizer;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.ProcessExecutor;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.glassfish.hk2.Services;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.paas.gfplugin.GlassFishPluginConstants;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.TemplateCustomizer;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualCluster;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="Native-JavaEE")
public class LocalGlassFishTemplateCustomizer
implements TemplateCustomizer,
GlassFishPluginConstants {
    @Inject
    Domain domain;
    @Inject
    RuntimeContext rtContext;
    @Inject
    private ServerContext serverContext;
    @Inject
    Services services;
    @Inject
    GMSAdapterService gmsAdapterService;

    public void customize(VirtualCluster cluster, final VirtualMachine virtualMachine) throws VirtException {
        if (provisionDAS) {
            return;
        }
        ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
        String[] createArgs = new String[]{this.getAsAdminCommand(), "create-local-instance", "--cluster", cluster.getConfig().getName(), virtualMachine.getName()};
        ProcessExecutor createInstance = new ProcessExecutor(createArgs);
        try {
            createInstance.execute();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
        for (Server instance : cluster.getConfig().getInstances()) {
            if (!instance.getName().equals(virtualMachine.getName())) continue;
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Server>(){

                    public Object run(Server wServer) throws PropertyVetoException, TransactionFailure {
                        Property property = (Property)wServer.createChild(Property.class);
                        property.setName("ServerPool");
                        property.setValue(virtualMachine.getServerPool().getName());
                        wServer.getProperty().add(property);
                        return null;
                    }
                }, (ConfigBeanProxy)instance);
            }
            catch (TransactionFailure transactionFailure) {
                RuntimeContext.logger.log(Level.SEVERE, "Cannot add properties to newly created instance configuration", transactionFailure);
                throw new VirtException((Throwable)transactionFailure);
            }
        }
    }

    public boolean isActive(VirtualCluster virtualCluster, VirtualMachine virtualMachine) throws VirtException {
        if (virtualMachine.getInfo().getState().equals((Object)Machine.State.READY)) {
            GMSAdapter adapter = this.gmsAdapterService.getGMSAdapterByName(virtualCluster.getConfig().getName());
            HealthHistory.InstanceHealth instanceHealth = adapter.getHealthHistory().getHealthByInstance(virtualMachine.getName());
            return instanceHealth.state.equals((Object)HealthHistory.STATE.RUNNING);
        }
        return false;
    }

    public void clean(VirtualMachine virtualMachine) {
        if (provisionDAS) {
            return;
        }
        String instanceName = virtualMachine.getName();
        Server instance = this.domain.getServerNamed(instanceName);
        if (instance != null) {
            ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
            this.rtContext.executeAdminCommand(report, "delete-instance", instanceName, new String[0]);
        }
    }

    public String getAsAdminCommand() {
        String[] args = new String[]{this.serverContext.getInstallRoot().getAbsolutePath()};
        return ASADMIN_COMMAND.format(args).toString();
    }

    public void start(VirtualMachine virtualMachine, boolean firstStart) {
        if (provisionDAS) {
            return;
        }
        String[] startArgs = new String[]{this.getAsAdminCommand(), "start-local-instance", virtualMachine.getName()};
        ProcessExecutor startInstance = new ProcessExecutor(startArgs);
        try {
            startInstance.execute();
        }
        catch (ExecException e) {
            e.printStackTrace();
        }
    }

    public void stop(VirtualMachine virtualMachine) {
        if (provisionDAS) {
            return;
        }
        String instanceName = virtualMachine.getName();
        Server instance = this.domain.getServerNamed(instanceName);
        if (instance != null) {
            ActionReport report = (ActionReport)this.services.forContract(ActionReport.class).named("plain").get();
            this.rtContext.executeAdminCommand(report, "stop-instance", instanceName, new String[]{"_vmShutdown", "false"});
        }
    }
}

